<?php

namespace App\Exports;
use App\Models\FGS\dc_transfer_stock;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithStyles;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Events\AfterSheet;
use Maatwebsite\Excel\Concerns\WithPreCalculateFormulas;

class DCstockExport implements FromCollection,WithHeadings, WithStyles,WithEvents,WithPreCalculateFormulas

{
    private $data;

    public function __construct($data) 
    {
        $this->data = $data;
    }
    public function collection()
    {
        $i=1;
        $data = [];
        $total = 0;
        foreach($this->data as $stk)
        {
            //print_r($stk);exit;
           
            if ($stk['expiry_date'] != '0000-00-00' && strtotime($stk['expiry_date']) >= strtotime('1990-01-01')) {
                $expiry = date('d-m-Y', strtotime($stk['expiry_date']));
            }
            else 
            $expiry = 'NA';  
          //  $stk = (array) $stk; // ✅ convert to array first

            $data[]= array(
                               //dd($stk['firm_name']),

                '#'=>$i++,
                'sku_code'=>$stk['sku_code'],
                'hsn'=>$stk['hsn_code'],
                'discription'=>$stk['discription'],
               // print_r($stk['prdt_description']),
                'category'=>$stk['category_name'],
                'new category'=>$stk['newcat'],
                'batchno'=>$stk['batch_no'],
                'quantity'=>$stk['quantity'],
                'uom'=>'Nos',
                'customer'=>$stk['firm_name'],
               // dd($stk['firm_name']),
                'location'=>$stk['location_name'],
                'mfg_date' => $stk['fgs_manufacturing_date'] && $stk['fgs_manufacturing_date'] !== '1970-01-01'
    ? date('d-m-Y', strtotime($stk['fgs_manufacturing_date']))
    : 'NA',

'expiry_date' => $stk['fgs_expiry_date'] && $stk['fgs_expiry_date'] !== '0000-00-00' && strtotime($stk['fgs_expiry_date']) >= strtotime('1990-01-01')
    ? date('d-m-Y', strtotime($stk['fgs_expiry_date']))
    : 'NA',
                'purchase_rate' => $stk['purchase'],
              
                
                

            );
        }
      // print_r($data);exit;
        return collect($data);
    }
    public function headings(): array
    {
        return [
            '#',
            'SKU Code',
            'HSN Code',
            'Description',
            'Business Category',
            'Product Category',
            'Batchcard',
            'Quantity',
            'UOM',
            'Customer',
            'Location Name',
            'Mfg. Date',
            'Expiry Date',
            'Purchase Rate',

            
            

        ];
    }
    public function styles(Worksheet $sheet)
    {           
        $numOfRows = count($this->data)+1;
        $totalRow = $numOfRows + 2;


        // Add cell with SUM formula to last row
       
    }
    public function registerEvents(): array
    {
        return [
            AfterSheet::class    => function(AfterSheet $event) {
                $event->sheet->getDelegate()->getColumnDimension('A')->setWidth(5);
                $event->sheet->getDelegate()->getColumnDimension('B')->setWidth(15);
                $event->sheet->getDelegate()->getColumnDimension('D')->setWidth(15);
                $event->sheet->getDelegate()->getColumnDimension('E')->setWidth(15);
                $event->sheet->getDelegate()->getColumnDimension('F')->setWidth(15);
                $event->sheet->getDelegate()->getColumnDimension('G')->setWidth(15);
                $event->sheet->getDelegate()->getColumnDimension('H')->setWidth(15);
                $event->sheet->getDelegate()->getColumnDimension('I')->setWidth(15);
                $event->sheet->getDelegate()->getColumnDimension('J')->setWidth(15);
                $event->sheet->getDelegate()->getColumnDimension('K')->setWidth(15);
          
                // $cellRange = 'F1:F20000';
                // $event->sheet->getDelegate()->getStyle($cellRange)->getAlignment()->setWrapText(true);
            },
        ];
    }
}

