<?php

namespace App\Exports;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithStyles;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;
use Maatwebsite\Excel\Concerns\WithEvents;
use Carbon\Carbon;
use Maatwebsite\Excel\Concerns\FromCollection;

class FGSgrstransactionExport implements FromCollection, WithHeadings, WithStyles,WithEvents
{
    private $items;

    public function __construct($items) 
    {
        $this->items = $items;
    }
    public function collection()
    {
        $i=1;
        $data = [];
        foreach($this->items as $item)
        {
            if (date('m', strtotime($item->grs_date)) == 6 || date('m', strtotime($item->grs_date)) == 5 || date('m', strtotime($item->grs_date)) == 4) {
                $qtr = "Q1";
            }
            if (date('m', strtotime($item->grs_date)) == 7 || date('m', strtotime($item->grs_date)) == 8 || date('m', strtotime($item->grs_date)) == 9) {
                $qtr = "Q2";
            }
            if (date('m', strtotime($item->grs_date)) == 10 || date('m', strtotime($item->grs_date)) == 11 || date('m', strtotime($item->grs_date)) == 12) {
                $qtr = "Q3";
            }
            if (date('m', strtotime($item->grs_date)) == 1 || date('m', strtotime($item->grs_date)) == 2 || date('m', strtotime($item->grs_date)) == 3) {
                $qtr = "Q4";
            }
    
            // Financial year
            $currentDate = Carbon::now();
            $currentYear = $currentDate->year;
    
            if ($currentDate->month >= 4) {
                $startYear = $currentYear;
                $endYear = $currentYear + 1;
            } else {
                $startYear = $currentYear - 1;
                $endYear = $currentYear;
            }
            $financialYear = $startYear . '-' . substr($endYear, -2);
           // dd($financialYear);
            // ✅ Condition for location1_name display
            $allowed_location_ids = [15,16,17,18,21,22,23];

            if (in_array($item->location1_id, $allowed_location_ids)) {
                $stock_decrease_sub = $item->location1_name;
            } else {
                $stock_decrease_sub = '';
            }
            
    
            $data[] = array(
                '#' => $i++,
                'doc_no' => $item->grs_number,
                'doc_date' => date('d-m-Y', strtotime($item->grs_date)),
                'oef_no' =>$item->oef_number,
                'customer_name' => $item->firm_name,
                'item_code' => $item['sku_code'],
                'description' => $item['discription'],
                'qty' => $item->quantity,
                'stock_decrease_main'=>$item->location1_name,
                'stock_decrease_sub'=>$stock_decrease_sub, // ✅ Updated here
                'stock_increase_main'=>$item->location2_name,
                'stock_increase_sub'=>$item->location2_name,
                'Zone' => $item->zone_name,
                'State' => $item->state_name,
                'City' => $item->city,
                'Product Category' => $item->category_name,
                'Business Category' => $item->new_category_name,
                'Sales Type' => $item->sales_type,
                'Month' => date('F', strtotime($item->grs_date)),
                'Qtr' => $qtr,
                'CY(Calender Year)' => date('Y', strtotime($item->grs_date)),
                'FY(Financial Year)' => $financialYear
            );
        }
        return collect($data);
    }
    
    public function headings(): array
        {
        return [
            '#',
            
            'Doc No',
            'Doc Date',
            'OEF No',
            'Customer Name',
            'Item Code',
            'Description',
            'Qty',
            'Stock Location Decrease-Main',
            'Stock Location Decrease-Sub',
            'Stock Location Increase-Main',
            'Stock Location Increase-Sub',
            'Zone',
            'State',
            'City',
            'Business Category',
            'Product Category',
            //'Transaction Type',
            'Sales Type',
           // 'Remarks',
            'Month',
            'Qty',
            'CY(Calender Year)',
            'FY(Financial Year)'
            // '#',
            // 'GRS Number',
            // 'GRS Date',
            // 'OEF Number',
            // 'OEF Date',
            // 'Order Number',
            // 'Order Date',
            // 'Product Sku Code',
            // 'HSNCode',
            // 'Description',
            // 'Quantity',
            // 'Outstanding Quantity',
            // 'Unit',
            // 'Manufacturing date',
            // 'Expiry date',
            // 'Customer',
            // 'WEF',
        ];
    }
    public function styles(Worksheet $sheet)
    {   
        
        return [
        // Style the first row as bold text.
        1    => ['font' => ['size' => 12,'bold' => true]],
        ];
    }
    public function registerEvents(): array
    {
        return [
            AfterSheet::class    => function(AfterSheet $event) {
                
                $event->sheet->getDelegate()->getColumnDimension('A')->setWidth(5);
                $event->sheet->getDelegate()->getColumnDimension('B')->setWidth(15);
                $event->sheet->getDelegate()->getColumnDimension('C')->setWidth(18);
                $event->sheet->getDelegate()->getColumnDimension('D')->setWidth(15);
                $event->sheet->getDelegate()->getColumnDimension('E')->setWidth(10);
                $event->sheet->getDelegate()->getColumnDimension('F')->setWidth(15);
                $event->sheet->getDelegate()->getColumnDimension('G')->setWidth(15);
              
                
                // $cellRange = 'F1:F20000';
                // $event->sheet->getDelegate()->getStyle($cellRange)->getAlignment()->setWrapText(true);
            },
        ];
    }

}
