<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithStyles;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Events\AfterSheet;
use App\Models\PurchaseDetails\inv_purchase_req_item;


class RequisitionItems implements FromCollection, WithHeadings, WithStyles,WithEvents
{
    /**
    * @return \Illuminate\Support\Collection
    */
    private $pr_id;

    public function __construct($pr_id) 
    {
        //$this->status = $status;
        $this->pr_id = $pr_id;
    }
    public function collection()
    {
        $items= inv_purchase_req_item::select(['inv_purchase_req_item.requisition_item_id','inv_purchase_req_item.actual_order_qty','inv_item_type.type_name',
        'inv_purchase_req_item_approve.created_user','inventory_rawmaterial.item_code','inventory_rawmaterial.hsn_code','inventory_rawmaterial.short_description',
        'inv_purchase_req_item_approve.approved_qty','inv_purchase_req_master.pr_no','inv_purchase_req_master.PR_SR','inv_unit.unit_name','inv_purchase_req_item_approve.status'])
                ->leftjoin('inv_purchase_req_master_item_rel','inv_purchase_req_master_item_rel.item','=','inv_purchase_req_item.requisition_item_id')
                ->leftjoin('inv_purchase_req_master','inv_purchase_req_master.master_id','=','inv_purchase_req_master_item_rel.master')
                ->leftjoin('inv_purchase_req_item_approve','inv_purchase_req_item_approve.pr_item_id', '=', 'inv_purchase_req_item.requisition_item_id')
                ->leftjoin('inventory_rawmaterial','inventory_rawmaterial.id','=','inv_purchase_req_item.Item_code')
                ->leftjoin('inv_item_type','inv_item_type.id', '=', 'inventory_rawmaterial.item_type_id')
                ->leftjoin('inv_unit', 'inv_unit.id','=', 'inventory_rawmaterial.issue_unit_id')
                ->where('inv_purchase_req_master.master_id','=',$this->pr_id)
                ->groupBy('inv_purchase_req_item.requisition_item_id')
                ->orderby('inv_purchase_req_item.requisition_item_id','desc')
                ->get();
        $i=1;
        $data = [];
        foreach ($items as $item) {
            $status = 'Unknown'; // Default value to avoid undefined variable
        
            if ($item['status'] == 4)
                $status = 'Pending';
            if ($item['status'] == 5)
                $status = 'On hold';
            if ($item['status'] == 1)
                $status = 'Approved';
            if ($item['status'] == 0)
                $status = 'Rejected';
        
            $data[] = array(
                '#' => $i++,
                'item_code' => $item['item_code'],
                'hsn_code' => $item['hsn_code'],
                'item_type' => $item['type_name'],
                'description' => $item['short_description'],
                'actual_order_qty' => $item['actual_order_qty'],
                'unit' => $item['unit_name'],
                'status' => $status,
            );
        }
        
        return collect($data);
    }
    public function headings(): array
    {
        return [
            '#',
            'Item Code',
            'HSN/SAC Code',
            'Item Type',
            'Item Description',
            'Order Quantity',
            'Unit',
            'Status',
            // 'Created At',
            // 'Last Updated At',
        ];
    }
    public function styles(Worksheet $sheet)
    {   
        
        return [
        // Style the first row as bold text.
        1    => ['font' => ['size' => 12,'bold' => true]],
        ];
    }
    public function registerEvents(): array
    {
        return [
            AfterSheet::class    => function(AfterSheet $event) {
                
                $event->sheet->getDelegate()->getColumnDimension('A')->setWidth(5);
                $event->sheet->getDelegate()->getColumnDimension('B')->setWidth(18);
                $event->sheet->getDelegate()->getColumnDimension('C')->setWidth(15);
                $event->sheet->getDelegate()->getColumnDimension('D')->setWidth(15);
                $event->sheet->getDelegate()->getColumnDimension('E')->setWidth(50);
                $event->sheet->getDelegate()->getColumnDimension('F')->setWidth(10);
                $event->sheet->getDelegate()->getColumnDimension('G')->setWidth(10);
                $event->sheet->getDelegate()->getColumnDimension('H')->setWidth(10);
                $event->sheet->getDelegate()->getColumnDimension('I')->setWidth(10);
                // $cellRange = 'F1:F20000';
                // $event->sheet->getDelegate()->getStyle($cellRange)->getAlignment()->setWrapText(true);
            },
        ];
    }
}
