<?php

namespace App\Http\Controllers\Web\PurchaseDetails;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Validator;
use DB;
use App\Models\User;
use App\Models\PurchaseDetails\inv_supplier_invoice_master;
use App\Models\PurchaseDetails\inv_miq;
use App\Models\PurchaseDetails\inv_miq_item;
use App\Models\PurchaseDetails\inv_miq_item_rel;
use App\Models\PurchaseDetails\inv_supplier_invoice_rel;
use App\Models\PurchaseDetails\inv_supplier_invoice_item;
use App\Models\PurchaseDetails\inv_final_purchase_order_master;
use App\Models\PurchaseDetails\inv_purchase_req_quotation_item_supp_rel;
use App\Models\currency_exchange_rate;
use Maatwebsite\Excel\Facades\Excel;
use App\Exports\MIQExport;
use App\Exports\MIQQuarantineExport;

class MIQController extends Controller
{
    public function __construct()
    {
        $this->User = new User;
        $this->inv_miq = new inv_miq;
        $this->inv_miq_item = new inv_miq_item;
        $this->inv_miq_item_rel = new inv_miq_item_rel;
        $this->inv_final_purchase_order_master = new inv_final_purchase_order_master;
        $this->inv_supplier_invoice_rel = new inv_supplier_invoice_rel;
        $this->inv_supplier_invoice_master = new inv_supplier_invoice_master;
        $this->inv_purchase_req_quotation_item_supp_rel = new inv_purchase_req_quotation_item_supp_rel;
        $this->inv_supplier_invoice_item = new inv_supplier_invoice_item;
        $this->currency_exchange_rate = new currency_exchange_rate;
    }
    public function MIQlist(Request $request)
    {   
      //  dd('check');
        $condition = [];
        if($request)
        {
            if ($request->miq_no) {
                $condition[] = ['inv_miq.miq_number','like', '%' . $request->miq_no . '%'];
            }
            if ($request->invoice_no) {
                $condition[] = ['inv_supplier_invoice_master.invoice_number','like', '%' . $request->invoice_no . '%'];
            }
            if($request->supplier)
            {
                $condition[] = [DB::raw("CONCAT(inv_supplier.vendor_id,' - ',inv_supplier.vendor_name)"), 'like', '%' . $request->supplier . '%'];
            }
            
            if ($request->from) {
                $condition[] = ['inv_miq.miq_date', '>=', date('Y-m-d', strtotime('01-' . $request->from))];
                $condition[] = ['inv_miq.miq_date', '<=', date('Y-m-t', strtotime('01-' . $request->from))];
            }
            $data['miq']= $this->inv_miq->get_all_data($condition);
        }
        else
        $data['miq']= $this->inv_miq->get_all_data($condition=null);
        return view('pages.inventory.MIQ.MIQ-list',compact('data'));
    }
    public function MIQAdd(Request $request, $id = null)
{
   // dd('check');
    if ($request->isMethod('post')) {
        $validation = [
            'miq_date' => ['required', 'date'],
            'invoice_number' => ['required'],
            'created_by' => ['required'],
        ];
        $validator = Validator::make($request->all(), $validation);

        if (!$validator->fails()) {

            // ✅ For CREATE NEW
            if (!$request->id) {

                // 🔢 Generate year combo
                if (date('m') == "01" || date('m') == "02" || date('m') == "03") {
                    $years_combo = date('y', strtotime('-1 year')) . date('y');
                } else {
                    $years_combo = date('y') . date('y', strtotime('+1 year'));
                }

                // 🔎 Determine item type
                $item_type = $this->item_type($request->invoice_number);

                // 🔢 Generate MIQ number +1 of latest existing with uniqueness check
               if ($item_type == "Direct Items") {
    $prefix = "MIQ2-" . $years_combo;
    $latest_miq = DB::table('inv_miq')
        ->where('miq_number', 'LIKE', $prefix . '-%')
        ->select(DB::raw('miq_number, CAST(SUBSTRING_INDEX(miq_number, "-", -1) AS UNSIGNED) as number_part'))
        ->orderBy('number_part', 'DESC')
        ->first();
       // dd($latest_miq);

    if ($latest_miq) {
        $last_number = intval($latest_miq->number_part);
        $new_number = $last_number + 1;
      //  dd($new_number);
    } else {
        $new_number = 1;
    }

    // 🔁 Check uniqueness in loop
    do {
        $miq_number = $prefix . '-' . $new_number;
        $exists = DB::table('inv_miq')->where('miq_number', $miq_number)->exists();
        if ($exists) {
            $new_number++;
        }
    } while ($exists);

    $Data['miq_number'] = $miq_number;
}

 else {
                    // ✅ Indirect Items MIQ3-
                    $prefix = "MIQ3-" . $years_combo;
                    $latest_miq = DB::table('inv_miq')
                        ->where('miq_number', 'LIKE', $prefix . '%')
                        ->orderBy('miq_number', 'DESC')
                        ->first();
                    //dd($years_combo, $prefix, $latest_miq);

                    if ($latest_miq) {
                        $parts = explode('-', $latest_miq->miq_number);
                        $last_number = intval(end($parts));
                        $new_number = $last_number + 1;
                     //   dd($new_number);
                    } else {
                        $new_number = 1;
                    }

                    // 🔁 Check uniqueness in loop
                    do {
                        $miq_number = $prefix . '-' . $new_number;
                        $exists = DB::table('inv_miq')->where('miq_number', $miq_number)->exists();
                        if ($exists) {
                            $new_number++;
                        }
                    } while ($exists);

                    $Data['miq_number'] = $miq_number;
                }

                // 📅 Save MIQ master
                $Data['miq_date'] = date('Y-m-d', strtotime($request->miq_date));
                $Data['invoice_master_id'] = $request->invoice_number;
                $Data['created_by'] = $request->created_by;
                $Data['status'] = 1;
                $Data['created_at'] = date('Y-m-d H:i:s');
                $Data['updated_at'] = date('Y-m-d H:i:s');

                $add_id = $this->inv_miq->insert_data($Data);

                // 🔗 Insert related items
                $invoice_items = inv_supplier_invoice_rel::select('inv_supplier_invoice_rel.item', 'inv_supplier_invoice_item.item_id')
                    ->leftJoin('inv_supplier_invoice_item', 'inv_supplier_invoice_item.id', '=', 'inv_supplier_invoice_rel.item')
                    ->where('inv_supplier_invoice_rel.master', '=', $request->invoice_number)
                    ->whereIn('inv_supplier_invoice_item.is_merged', [0, 2])
                    ->get();

                foreach ($invoice_items as $item) {
                    $dat = [
                        'invoice_item_id' => $item->item,
                        'item_id' => $item->item_id,
                        'status' => 1,
                        'created_at' => date('Y-m-d H:i:s'),
                        'updated_at' => date('Y-m-d H:i:s')
                    ];

                    $item_id = $this->inv_miq_item->insert_data($dat);

                    $dat2 = [
                        'master' => $add_id,
                        'item' => $item_id,
                    ];
                    DB::table('inv_miq_item_rel')->insert($dat2);
                }

                if ($add_id) {
                    $request->session()->flash('success', "Now please edit the items and confirm submission!");
                } else {
                    $request->session()->flash('error', "MIQ creation failed. Try again!");
                }
                return redirect('inventory/MIQ-add/' . $add_id);
            }

            // ✅ For UPDATE EXISTING
            else {
                $Data = [
                    'miq_date' => date('Y-m-d', strtotime($request->miq_date)),
                    'invoice_master_id' => $request->invoice_number,
                    'created_by' => $request->created_by,
                    'updated_at' => date('Y-m-d H:i:s'),
                ];

                $update = $this->inv_miq->update_data(['inv_miq.id' => $request->id], $Data);

                if ($update) {
                    $request->session()->flash('success', "You have successfully updated MIQ!");
                } else {
                    $request->session()->flash('error', "MIQ update failed. Try again!");
                }
                return redirect('inventory/MIQ-add/' . $request->id);
            }
        }

        // 🔴 Validation failed
        if ($request->id) {
            return redirect('inventory/MIQ-add/' . $request->id)->withErrors($validator)->withInput();
        } else {
            return redirect('inventory/MIQ-add')->withErrors($validator)->withInput();
        }
    }

    // ✅ For GET method - Load page with users and MIQ data
    $condition1[] = ['user.status', '=', 1];
    $data['users'] = $this->User->get_all_users($condition1);

    if ($request->id) {
        $data['miq'] = $this->inv_miq->get_data(['inv_miq.id' => $request->id]);
        $data['miq_items'] = $this->inv_miq_item->get_items(['inv_miq_item_rel.master' => $request->id]);
    }

    return view('pages.inventory.MIQ.MIQ-add', compact('data'));
}

    
    function item_type($invoice_number){
        $item_type = inv_supplier_invoice_rel::leftJoin('inv_supplier_invoice_item','inv_supplier_invoice_item.id','=','inv_supplier_invoice_rel.item')
                            ->leftJoin('inv_purchase_req_item','inv_purchase_req_item.requisition_item_id','=','inv_supplier_invoice_item.item_id')
                            ->leftJoin('inventory_rawmaterial','inventory_rawmaterial.id','=','inv_purchase_req_item.requisition_item_id')
                            ->leftJoin('inv_item_type','inv_item_type.id','=','inventory_rawmaterial.item_type_id')
                            ->where('inv_supplier_invoice_rel.master','=', $invoice_number)->pluck('inv_item_type.type_name')->first();
        return $item_type;
    }

    public function MIQAddItemInfo(Request $request, $id)
    {
        if ($request->isMethod('post')) {
            //$validation['lot_number'] = ['required'];
            $validation['currency'] = ['required'];
            $validation['conversion_rate'] = ['required'];
            $validation['value_inr'] = ['required'];
            $validation['expiry_control'] = ['required'];
            $validation['expiry_date'] = ['required'];
            $validator = Validator::make($request->all(), $validation);
            if(!$validator->errors()->all()){
                $data['lot_number'] =$request->lot_number;
                $data['currency'] = $request->currency;
                $data['conversion_rate']= $request->conversion_rate;
                $data['value_inr']= $request->value_inr;
                $data['expiry_date']=date('Y-m-d', strtotime($request->expiry_date));
                $data['expiry_control'] =$request->expiry_control;
                $update = $this->inv_miq_item->update_data(['inv_miq_item.id'=>$request->id],$data);
                $miq_id = inv_miq_item_rel::where('item','=',$request->id)->pluck('master')->first();
                if($update)
                    $request->session()->flash('success', "You have successfully updated a MIQ Item Info!");
                else
                    $request->session()->flash('error', "MIQ Item info updation is failed. Try again... !");
                return redirect('inventory/MIQ-add/'.$miq_id);
            }
            if($validator->errors()->all()){
                return redirect('inventory/MIQ/'.$request->id.'/item')->withErrors($validator)->withInput();
            }
        }
        $data = $this->inv_miq_item->get_item(['inv_miq_item.id'=>$id]);
        //print_r(json_encode($data));
        $currency = $this->currency_exchange_rate->get_currency([]);
       // echo $currency;
        return view('pages.inventory.MIQ.MIQ-itemInfo-add',compact('data','currency'));
    }

    public function findInvoiceNumber(Request $request)
{
    if ($request->q) {
        $condition = [
            ['inv_supplier_invoice_master.invoice_number', 'like', '%' . $request->q . '%']
        ];

        $data = $this->inv_supplier_invoice_master->find_invoice_num($condition);

        // Filter invoices that have items
        $filtered = $data->filter(function($invoice) {
            return DB::table('inv_supplier_invoice_rel')
                ->join('inv_supplier_invoice_item', 'inv_supplier_invoice_rel.item', '=', 'inv_supplier_invoice_item.id')
                ->where('inv_supplier_invoice_rel.master', $invoice->id)
                ->exists();
        })->values();

        return response()->json($filtered, 200);
    } else {
        echo $this->invoice_details($request->id, null);
        exit;
    }
}

    
    
    public function miq_delete(Request $request, $id)
    {

        $this->inv_miq->update_data(['id' => $id],['status'=>0]);
        $request->session()->flash('success', "You have successfully deleted a MIQ !");
        return redirect("inventory/MIQ");
    }

    public function getCurrency($invoice_item_id)
    {
        $po_master_id = inv_supplier_invoice_item::where('id','=',$invoice_item_id)->pluck('po_master_id')->first();
        // dd($po_master_id);
        if(!$po_master_id)
        {
            $po_master_id = inv_supplier_invoice_item::where('merged_invoice_item','=',$invoice_item_id)->pluck('po_master_id')->first();
        }
        $po_master = inv_final_purchase_order_master::where('id','=',$po_master_id)->first();
        // print_r($po_master_id);exit;
        if(isset($po_master)) 
        {
        $currency = inv_purchase_req_quotation_item_supp_rel::where('quotation_id','=',$po_master['rq_master_id'])->where('supplier_id','=',$po_master['supplier_id'])
        ->leftJoin('currency_exchange_rate','currency_exchange_rate.currency_id', '=', 'inv_purchase_req_quotation_item_supp_rel.currency')
        ->where('inv_purchase_req_quotation_item_supp_rel.selected_item','=',1)
                            ->pluck('currency_id')->first();
        return $currency;
        }else{
            return null;
 
        }
    }

    public function MIQExport(Request $request)
    {
        if($request)
        {
            return Excel::download(new MIQExport($request), 'MIQ' . date('d-m-Y') . '.xlsx');
        }
        else
        {
            $request =null;
            return Excel::download(new MIQExport($request), 'MIQ' . date('d-m-Y') . '.xlsx');
        }
    }
    public function MIQQuarantineExport(Request $request)
    {
        if($request)
        {
            return Excel::download(new MIQQuarantineExport($request), 'QuarantineReport' . date('d-m-Y') . '.xlsx');
        }
        else
        {
            $request =null;
            return Excel::download(new MIQQuarantineExport($request), 'QuarantineReport' . date('d-m-Y') . '.xlsx');
        }
    }
      public function LiveQuarantineReport(Request $request)
    {   
      // dd('hi');
        $condition = [];
        if($request)
        {
            if ($request->miq_no) {
                $condition[] = ['inv_miq.miq_number','like', '%' . $request->miq_no . '%'];
            }
            if ($request->item_code) {
                $condition[] = ['inventory_rawmaterial.item_code','like', '%' . $request->item_code . '%'];
            }
            if($request->supplier)
            {
                $condition[] = [DB::raw("CONCAT(inv_supplier.vendor_id,' - ',inv_supplier.vendor_name)"), 'like', '%' . $request->supplier . '%'];
            }
            
            if ($request->from) {
                $condition[] = ['inv_miq.miq_date', '>=', date('Y-m-d', strtotime('01-' . $request->from))];
                $condition[] = ['inv_miq.miq_date', '<=', date('Y-m-t', strtotime('01-' . $request->from))];
            }
           //$data['miq']= $this->inv_miq_item->get_all_data_not_in_mac($condition);
           //$data['miq']= $this->inv_miq_item->get_items_not_in_mac($condition);
        }
        $data['miq']= $this->inv_miq_item->get_all_data_not_in_mac($condition);
//dd($data);
        return view('pages.inventory.MIQ.LiveQuarantineReport',compact('data'));
    }
    public function invoiceInfo(Request $request)
    {
//         print_r("check")
// ;exit;     
   if ($request->q) {
            $condition[] = ['inv_supplier_invoice_master.invoice_number', 'like', '%' . strtoupper($request->q) . '%'];
           
            $data = $this->inv_supplier_invoice_master->find_invoice_num($condition);
           // print_r($data);exit;
            if (!empty($data[0])) {
                return response()->json($data, 200);
            } else {
                return response()->json(['message' => 'item code is not valid'], 500);
            }
        } else {
            echo $this->invoice_details($request->id, null);
            exit;
        }
    }
    public function invoice_details($id, $active = null)
    {
        $invoice = $this->inv_supplier_invoice_master->get_master_data(['inv_supplier_invoice_master.id' => $id]);
        //return $invoice;
        $invoice_item = $this->inv_supplier_invoice_item->get_supplier_invoice_item_mac(['inv_supplier_invoice_rel.master' => $id]);
        // if ($active) {
        //     $inv_mac_item = $this->inv_mac_item->get_mac_items(['inv_mac_rel.master' => $active]);
        // }

        $data = '<div class="row">
           <div class="form-group col-sm-12 col-md-12 col-lg-12 col-xl-12" style="margin: 0px;">
               <label style="color: #3f51b5;font-weight: 500;margin-bottom:2px;">
                Supplier Invoice (' . $invoice->invoice_number . ')
                   </label>
               <div class="form-devider"></div>
           </div>
           </div>
           <table class="table table-bordered mg-b-0">
                <thead>
            
                </thead>
                <tbody>
                    <tr>
                        <th>Invoice Date</th>
                        <td>' . date('d-m-Y', strtotime($invoice->invoice_date)) . '</td>
                    </tr>
                    <tr>
                            <th>Created Date</th>
                            <td>' . date('d-m-Y', strtotime($invoice->invoice_created)) . '</td>
                    </tr>
                    <tr>
                        <th>Supplier ID</th>
                        <td>'.$invoice->vendor_id.'</td>
                        
                    </tr>
                    <tr>
                        <th>Supplier Name</th>
                        <td>'.$invoice->vendor_name.'</td>
                    </tr>
                </tbody>
           </table>
           <br>
           <div class="row">
           <div class="form-group col-sm-12 col-md-12 col-lg-12 col-xl-12" style="margin: 0px;">
               <label style="color: #3f51b5;font-weight: 500;margin-bottom:2px;">';
       
            $data .= 'Invoice Items ';
            $data .= '</label>
               <div class="form-devider"></div>
                </div>
                </div>
                <div class="table-responsive">
                <table class="table table-bordered mg-b-0" id="example1">';

        
            $data .= '<thead>
                   <tr>
                   <th>PR No</th>
                   <th>Item Code:</th>
                   <th>Lot No</th>
                   <th>Invoice Qty</th>
                   <th>Accepted Qty</th>
                   <th>Rate</th>
                   <th>Discount </th>
                   <th>GST </th>
                   
                   </tr>
               </thead>
               <tbody >';
            foreach ($invoice_item as $item) {
                $data .= '<tr>
                        <td>'.$item->pr_no.'</td>
                       <td>'.$item->item_code.'</td>
                       <td>'.$item->lot_number.'</td>
                       <td>'.$item->order_qty. $item->unit_name.'</td>
                       <td>'.$item->accepted_quantity. $item->unit_name.'</td>
                       <td>'.$item->rate.'</td>
                       <td>'.$item->discount.'</td>
                       <td>IGST:'.$item->igst.'% ,
                            SGST:'.$item->sgst.'%,
                            CGST:'.$item->cgst.'%<br/>
                       </td>
                       
                   </tr>';
            }
            $data .= '</tbody>';
        

        $data .= '</table>
       </div>';
        return $data;
    }


    
}
