<?php

namespace App\Http\Controllers\Web\PurchaseDetails;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Validator;
use DB;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use App\Models\User;
use App\Models\batchcard;
use App\Models\work_centre;
use App\Models\assembly_batchcards;
use App\Models\product_input_material;
use App\Models\batchcard_material;
use App\Models\PurchaseDetails\inv_lot_allocation;
use App\Models\PurchaseDetails\inv_miq_item;
use App\Models\PurchaseDetails\inv_mac_item;
use App\Models\PurchaseDetails\inv_stock_to_production;
use App\Models\PurchaseDetails\inv_stock_from_production;
use App\Models\PurchaseDetails\inv_stock_transfer_order;
use App\Models\PurchaseDetails\inv_stock_transfer_order_item;
use App\Models\PurchaseDetails\inventory_rawmaterial;
use App\Models\PurchaseDetails\inv_purchase_req_item;
use App\Models\PurchaseDetails\inv_stock_to_production_item;
use App\Models\PurchaseDetails\inv_batchcard_qty_updation_request;
use App\Models\PurchaseDetails\inv_stock_management;
use App\Models\PurchaseDetails\inv_stock_transaction;
use App\Models\PurchaseDetails\inv_transaction_slip;
use Maatwebsite\Excel\Facades\Excel;
use App\Exports\InventoryStockExport;
use App\Models\FGS\product_stock_location;
use App\Exports\AllSIPItemsExport;
use App\Exports\AllSTOItemsExport;
use App\Exports\AllSRPItemsExport;

class StockController extends Controller
{
    public function __construct()
    {
        $this->User = new User;
        $this->batchcard = new batchcard;
        $this->assembly_batchcards = new assembly_batchcards;
        $this->inv_miq_item = new inv_miq_item;
        $this->inv_mac_item = new inv_mac_item;
        $this->inv_purchase_req_item = new inv_purchase_req_item;
        $this->inventory_rawmaterial = new inventory_rawmaterial;
        $this->inv_lot_allocation = new inv_lot_allocation;
        $this->inv_stock_to_production = new inv_stock_to_production;
        $this->inv_stock_from_production = new inv_stock_from_production;
        $this->inv_stock_transfer_order = new inv_stock_transfer_order;
        $this->inv_stock_transfer_order_item = new inv_stock_transfer_order_item;
        $this->inv_stock_to_production_item = new inv_stock_to_production_item;
        $this->batchcard_material = new batchcard_material;
        $this->inv_batchcard_qty_updation_request = new inv_batchcard_qty_updation_request;
        $this->inv_stock_management = new inv_stock_management;
        $this->inv_stock_transaction = new inv_stock_transaction;
        $this->inv_transaction_slip = new inv_transaction_slip;
        
    }
    
    public function StockToProductionAdd(Request $request)
    {   
        return view('pages.inventory.stock.stock-issue-to-production-add');
    }

    public function findBatchCard(Request $request)
    {
        if(!$request->q){
            return response()->json(['message'=>'Batchcard is not valid'], 500); 
        }
        $condition[] = ['batchcard_batchcard.batch_no','like','%'.strtoupper($request->q).'%'];
        //$data = $this->batchcard->get_all_batchcards($condition);
       $data  = $this->inventory_rawmaterial->getItems($condition);
        if(!empty( $data)){
            return response()->json( $data, 200); 
        }else{
            return response()->json(['message'=>'Batchcard is not valid'], 500); 
        }
    }

    public function fetchBatchCard_items(Request $request)
    {
        $batchcards = batchcard_material::select('inventory_rawmaterial.item_code','inventory_rawmaterial.id as rawmaterial_id')
                ->leftJoin('batchcard_batchcard','batchcard_batchcard.id','=', 'batchcard_materials.batchcard_id')
                ->leftJoin('product_product','batchcard_batchcard.product_id','=', 'product_product.id')
                ->leftJoin('inventory_rawmaterial','inventory_rawmaterial.id','=','batchcard_materials.item_id')
                ->where('batchcard_materials.batchcard_id','=',$request->batchcard_id)
                ->get();
        return $batchcards;
        
    }
    public function fetchLotcard(Request $request)
    {
        // $data =[];
        // $sip_item = inv_stock_to_production_item::select('inv_stock_to_production_item.*','inv_unit.unit_name')
        //                                 ->leftJoin('inventory_rawmaterial','inventory_rawmaterial.id','=','inv_stock_to_production_item.material_id')
        //                                 ->leftJoin('inv_unit', 'inv_unit.id','=', 'inventory_rawmaterial.issue_unit_id')
        //                                 ->where('batchcard_id','=',$request->batchcard_id)
        //                                 ->where('material_id','=',$request->item_id)
        //                                 ->first();
        // $sip_master = DB::table('inv_stock_to_production_item_rel')->where('item', $sip_item['id'])->value('master');
        // $lot = inv_stock_to_production:: select('inv_lot_allocation.id as lot_id','inv_lot_allocation.lot_number','inv_mac_item.accepted_quantity','inv_mac_item.available_qty')
        //                             ->leftjoin('inv_lot_allocation','inv_lot_allocation.id','=','inv_stock_to_production.lot_id')
        //                             ->leftJoin('inv_supplier_invoice_item','inv_supplier_invoice_item.id','=','inv_lot_allocation.si_invoice_item_id')
        //                             ->leftJoin('inv_miq_item','inv_miq_item.lot_number','=','inv_lot_allocation.lot_number')
        //                             ->leftJoin('inv_mac_item','inv_mac_item.invoice_item_id','=','inv_lot_allocation.si_invoice_item_id')
        //                             ->where('inv_stock_to_production.id','=',$sip_master)
        //                             ->first();
        // $data['batch_qty']= $sip_item['qty_to_production'];
        // $data['lot_id'] = $lot['lot_id'];
        // $data['lot_number'] =$lot['lot_number'];
        // $data['accepted_quantity'] =$lot['accepted_quantity'];
        // $data['available_qty'] =$lot['available_qty'];
        // $data['unit_name'] = $sip_item['unit_name'];
        //  return $data;
        $lotcards = inv_lot_allocation::select('inv_lot_allocation.id as lot_id','inv_lot_allocation.lot_number','inv_unit.unit_name','inventory_rawmaterial.item_code',
        'inv_stock_management.stock_qty','inv_stock_management.id as stock_id')
                                        ->leftJoin('inv_stock_management','inv_stock_management.lot_id','=','inv_lot_allocation.id')
                                        ->leftJoin('inventory_rawmaterial','inventory_rawmaterial.id','=','inv_stock_management.item_id')
                                        ->leftJoin('inv_unit', 'inv_unit.id','=', 'inventory_rawmaterial.issue_unit_id')
                                        ->where('inventory_rawmaterial.id','=', $request->item_id)
                                        ->where('inv_stock_management.stock_qty','!=',0)
                                        ->where('inv_stock_management.status','=',1)
                                        ->orderBy('inv_lot_allocation.id','asc')
                                        ->get();
                                        //return $lotcards;
                                     //   dd($lotcards);exit;
        if(count($lotcards)>0)
        {
            $data = "<div style='color:#3366ff;font: size 15px;'><i class='fas fa-address-card' style='font-size:21px;'></i>&nbsp;<strong>LotCards</strong></div>
                        <div class='row'>
                            <div class='table-responsive'>
                                <table class='table table-bordered mg-b-0' id='example1' >
                                    <thead>
                                        <tr>
                                            <th></th>
                                            <th>LotBCard</th>
                                            <th>Item Code</th>
                                            <th>Quantity</th>
                                        </tr>
                                    </thead>
                                    <tbody>";
                                    $i=1;                                       
                                    foreach($lotcards as $card)
                                    {
                                        $data .="<tr>
                                                    <td><input type='radio' required class='lot-radio' name='lot_id' value='".$card->lot_id."' lotqty='".$card->stock_qty."' lotno='".$card->lot_number."' macItemid=".$card->stock_id."></td>
                                                    <th>".$card->lot_number."</th>
                                                    <th>".$card->item_code."</th>
                                                    <th>".$card->stock_qty." ".$card->unit_name."</th>
                                                </tr> ";                                               
                                        $i++;
                                    }
            $data .="<tbody></table></div></div>";
        }
        if($data)                               
        return $data;
        else
        return 0;
    }

    public function fetchBatchCard_info(Request $request)
    {
        $batchcard_id = $request->batchcard_id;
        $data['batchcard'] = $this->batchcard->get_batchcard(['batchcard_batchcard.id'=>$request->batchcard_id]);
        if($data['batchcard']['is_assemble']==1)
        {
            $primary_sku_batchcards = assembly_batchcards::select('assembly_batchcards.id','batchcard_batchcard.id as batch_id','batchcard_batchcard.batch_no','assembly_batchcards.quantity','inventory_rawmaterial.item_code')
                                    ->leftJoin('batchcard_batchcard','batchcard_batchcard.id','=','assembly_batchcards.primary_sku_batchcard_id')
                                    ->leftJoin('inventory_rawmaterial','inventory_rawmaterial.id','=','batchcard_batchcard.input_material')
                                    ->where('assembly_batchcards.main_batchcard_id','=',$request->batchcard_id)
                                    ->get();
            //return $primary_sku_batchcards;
            $data['batch'] = '&nbsp;
                            <label>BatchCard</label>
                            <table  class="table table-bordered mg-b-0" id="example1">
                            <tr>
                            <th>#</th>
                                <th>Batch Number</th>
                                <th>Qty</th>
                            </tr>
                            <tbody class="data-bindings1">';
            foreach($primary_sku_batchcards as $batch)
            {
                $data['batch'] .= '<tr>
                        <td><input type="radio" id="batch_radio" name="assemble_item_id"  value="'.$batch['batch_id'].'" data-batchno="'.$batch['batch_no'].'" data-qty="'.$batch['quantity'].'" ></td>
                        <td>'.$batch['batch_no'].'</td>
                    
                        <td>'.$batch['quantity'].'</td>
                        </tr>';
            }
            $data['batch'] .='<tbody>
            </table>';
        
            
        }
        else
        {
            $lotcard = $this->inv_lot_allocation->getLots_sip(['inv_purchase_req_item.item_code'=>$data['batchcard']['input_material']]);
            $data['lot'] = '&nbsp;
                            <label>Lotcard</label>
                            <table  class="table table-bordered mg-b-0" id="example1">
                            <tr>
                            <th>#</th>
                                <th>Lot Number</th>
                                <th>Item</th>
                                <th>Qty</th>
                            </tr>
                            <tbody class="data-bindings1">';
            foreach($lotcard as $lot)
            {
                $data['lot'] .= '<tr>
                        <td><input type="radio" id="lot_radio" name="lot_id" lot="'.$lot['lot_number'].'" qty="'.$lot['available_qty'].'" value="'.$lot['id'].'"></td>
                        <td>'.$lot['lot_number'].'</td>
                        <td>'.$lot['item_code'].'</td>
                        <td>'.$lot['available_qty'].'</td>
                        </tr>';
            }
            $data['lot'] .='<tbody>
            </table>';
        }
        return $data;
    }

    public function fetchPrimaryBatchCard_info(Request $request)
    {
        //echo "hh";
        $primary_sku_batchcards = assembly_batchcards::select('assembly_batchcards.id','batchcard_batchcard.batch_no','assembly_batchcards.quantity','inventory_rawmaterial.item_code','inventory_rawmaterial.discription')
                                    ->leftJoin('batchcard_batchcard','batchcard_batchcard.id','=','assembly_batchcards.primary_sku_batchcard_id')
                                    ->leftJoin('inventory_rawmaterial','inventory_rawmaterial.id','=','batchcard_batchcard.input_material')
                                    ->where('assembly_batchcards.primary_sku_batchcard_id','=',$request->batchcard_id)
                                    ->get();
        return $primary_sku_batchcards;
    }
    
    public function getSingleSIP(Request $request)
    {
        $sip = inv_stock_to_production::select('inv_stock_to_production.*','inventory_rawmaterial.item_code','inv_unit.unit_name')
                                ->leftJoin('inv_purchase_req_item','inv_purchase_req_item.requisition_item_id','=','inv_stock_to_production.pr_item_id')
                                ->leftjoin('inventory_rawmaterial','inventory_rawmaterial.id','=','inv_purchase_req_item.Item_code')
                                ->leftjoin('inv_unit', 'inv_unit.id','=', 'inventory_rawmaterial.issue_unit_id')
                                ->where('inv_stock_to_production.id','=', $request->sip_id)->first();
        return $sip;
    }

    public function get_mac_qty($invoice_item_id)
    {
        $mac_qty = inv_miq_item::leftJoin('inv_mac_item','inv_mac_item.miq_item_id','=','inv_miq_item.id')
                                ->where('inv_miq_item.invoice_item_id','=',$invoice_item_id)
                                ->pluck('inv_mac_item.accepted_quantity')
                                ->first();
        //if($mac_qty)
        return $mac_qty;
        
    }
    public function get_item_type($raw_material_id)
    {
        $item_type = inventory_rawmaterial::leftJoin('inv_item_type','inv_item_type.id','=','inventory_rawmaterial.item_type_id')
                                            ->where('inventory_rawmaterial.id','=',$raw_material_id)
                                            ->pluck('inv_item_type.type_name')
                                            ->first();
        return $item_type;
    }     
    public function StockToProductionEdit(Request $request)
    {
        $validation['quantity'] = ['required'];
        $validator = Validator::make($request->all(), $validation);
        if(!$validator->errors()->all())
        {
            $data['qty_to_production'] = $request->quantity;
            $data['updated_at'] = date('Y-m-d H:i:s');
            $update = $this->inv_stock_to_production->update_data(['id' => $request->sipId],$data);
            if($update)
            $request->session()->flash('success', "You have successfully updated Stock issue to production !");
            else
            $request->session()->flash('error', "Stock issue to production updation failed!");
            return redirect("inventory/Stock/ToProduction");
        }
        if($validator->errors()->all())
        {
           // $request->session()->flash('error', "Stock issue to production updation failed!");
            return redirect("inventory/Stock/ToProduction")->withErrors($validator)->withInput();
        }
    }                  

    public function StockToProductionDelete(Request $request,$id)
    {
        $delete = $this->inv_stock_to_production->update_data(['id' => $id],['status'=>0]);
        //$delete = $this->inv_stock_to_production->deleteData(['id' => $id]);
        if($delete)
        $request->session()->flash('success', "You have successfully deleted Stock issue to production !");
        else
        $request->session()->flash('error', "You have failed to delete Stock issue to production !");
        return redirect("inventory/Stock/ToProduction");
    }
    

    public function StockFromProduction(Request $request)
    {
       
        $condition = [];
        if($request)
        {
            if ($request->sir_number) {
                $condition[] = ['inv_stock_from_production.sir_number','like', '%' . $request->sir_number . '%'];
            }
            if ($request->lot_number) {
                $condition[] = ['inv_lot_allocation.lot_number','like', '%' . $request->lot_number . '%'];
            }
            if ($request->item_code) {
                $condition[] = ['inventory_rawmaterial.item_code','like', '%' . $request->item_code . '%'];
            }
            if($request->supplier)
            {
                $condition[] = [DB::raw("CONCAT(inv_supplier.vendor_id,' - ',inv_supplier.vendor_name)"), 'like', '%' . $request->supplier . '%'];
            }
           
        }
        $data['sir'] =$this->inv_stock_from_production->get_all_data($condition);
        return view('pages.inventory.stock.stock-from-production', compact('data'));
    }
    public function StockFromProductionAdd(Request $request)
    {
        
        // $condition = [];
        // if($request)
        // {
        //     if ($request->lot_number) {
        //         $condition[] = ['inv_lot_allocation.lot_number','like', '%' . $request->lot_number . '%'];
        //     }
        //     if ($request->item_code) {
        //         $condition[] = ['inventory_rawmaterial.item_code','like', '%' . $request->item_code . '%'];
        //     }
        //     if($request->supplier)
        //     {
        //         $condition[] = [DB::raw("CONCAT(inv_supplier.vendor_id,' - ',inv_supplier.vendor_name)"), 'like', '%' . $request->supplier . '%'];
        //     }
           
        // }
        // $data['items'] =$this->inv_stock_to_production->getSIP_Not_In_StockFromProduction($condition);
        
        return view('pages.inventory.stock.stock-from-production-add');
    }
    

    public function StockFromProductionDelete(Request $request,$id)
    {
        //$delete = $this->inv_stock_from_production->deleteData(['id' => $id]);
        $delete = $this->inv_stock_from_production->update_data(['id' => $id],['status'=>0]);
        if($delete)
        $request->session()->flash('success', "You have successfully deleted Stock return from production !");
        else
        $request->session()->flash('error', "You have failed to delete Stock return from production !");
        return redirect("inventory/Stock/FromProduction");
    }
    public function getSingleSIR(Request $request)
    {
        $sir = inv_stock_from_production::select('inv_stock_from_production.*','inventory_rawmaterial.item_code','inv_unit.unit_name')
                                ->leftJoin('inv_purchase_req_item','inv_purchase_req_item.requisition_item_id','=','inv_stock_from_production.pr_item_id')
                                ->leftjoin('inventory_rawmaterial','inventory_rawmaterial.id','=','inv_purchase_req_item.Item_code')
                                ->leftjoin('inv_unit', 'inv_unit.id','=', 'inventory_rawmaterial.issue_unit_id')
                                ->where('inv_stock_from_production.id','=', $request->sir_id)->first();
        return $sir;
    }
    public function StockFromProductionEdit(Request $request)
    {
        $validation['quantity'] = ['required'];
        $validator = Validator::make($request->all(), $validation);
        if(!$validator->errors()->all())
        {
            $data['quantity'] = $request->quantity;
            $data['updated_at'] = date('Y-m-d H:i:s');
            $update = $this->inv_stock_from_production->update_data(['id' => $request->sirId],$data);
            if($update)
            $request->session()->flash('success', "You have successfully updated Stock return from production !");
            else
            $request->session()->flash('error', "Stock return from production updation failed!");
            return redirect("inventory/Stock/FromProduction");
        }
        if($validator->errors()->all())
        {
           // $request->session()->flash('error', "Stock return from production updation failed!");
            return redirect("inventory/Stock/FromProduction")->withErrors($validator)->withInput();
        }
    }

    

    
    
    public function getSingleSTO(Request $request)
    {
        $sto = inv_stock_transfer_order::select('inv_stock_transfer_order.*','inventory_rawmaterial.item_code','inv_unit.unit_name')
                                ->leftJoin('inv_purchase_req_item','inv_purchase_req_item.requisition_item_id','=','inv_stock_transfer_order.pr_item_id')
                                ->leftjoin('inventory_rawmaterial','inventory_rawmaterial.id','=','inv_purchase_req_item.Item_code')
                                ->leftjoin('inv_unit', 'inv_unit.id','=', 'inventory_rawmaterial.issue_unit_id')
                                ->where('inv_stock_transfer_order.id','=', $request->sto_id)->first();
        return $sto;
    }
    public function StockTransferEdit(Request $request)
    {
        $validation['quantity'] = ['required'];
        $validator = Validator::make($request->all(), $validation);
        if(!$validator->errors()->all())
        {
            $data['quantity'] = $request->quantity;
            $data['updated_at'] = date('Y-m-d H:i:s');
            $update = $this->inv_stock_transfer_order->update_data(['id' => $request->stoId],$data);
            if($update)
            $request->session()->flash('success', "You have successfully updated Stock transfer order !");
            else
            $request->session()->flash('error', "Stock transfer Order updation failed!");
            return redirect("inventory/Stock/transfer");
        }
        if($validator->errors()->all())
        {
            //$request->session()->flash('error', "Stock transfer order updation failed!");
            return redirect("inventory/Stock/transfer")->withErrors($validator)->withInput();
        }
    }
    public function StockTransferDelete(Request $request,$id)
    {
        $delete = $this->inv_stock_transfer_order->deleteData(['id' => $id]);
        if($delete)
        $request->session()->flash('success', "You have successfully deleted Stock transfer Order!");
        else
        $request->session()->flash('error', "You have failed to delete Stock transfer Order !");
        return redirect("inventory/Stock/transfer");
    }






    public function PackingSIP()
    {
        $work_centre = work_centre::where('status','=',1)->get();
        return view('pages.inventory.stock.packing-sip',compact('work_centre'));
    }
    public function addPackingSIP(Request $request)
    {
        $validation['lot_id'] = ['required'];
        //$validation['batchcard'] = ['required'];
        $validation['work_centre'] = ['required'];
        $validation['qty_to_production'] = ['required'];
        $validator = Validator::make($request->all(), $validation);
        if(!$validator->errors()->all())
        {
            if(date('m')==01 || date('m')==02 || date('m')==03)
            {
                $years_combo = date('y', strtotime('-1 year')).date('y');
            }
            else
            {
                $years_combo = date('y').date('y', strtotime('+1 year'));
            }
            $lot_data= $this->inv_lot_allocation->get_single_lot1(['inv_lot_allocation.id'=>$request->lot_id]);
            $data['sip_number'] = "SIP2-".$this->year_combo_num_gen_inv(DB::table('inv_stock_to_production')->where('inv_stock_to_production.sip_number', 'LIKE', 'SIP2-'.$years_combo.'%')->count()); 
            $data['lot_id'] = $request->lot_id;
            $data['qty_to_production'] = $request->qty_to_production;
            $data['type'] = 2;
            $data['status'] = 1;
            $data['work_centre'] = $request->work_centre;
            $data['transaction_slip'] = $request->transaction_slip;
            $data['qty_to_production'] = $request->qty_to_production;
            $data['created_at']= date('Y-m-d H:i:s');
            $data['updated_at']= date('Y-m-d H:i:s');
        
            $mac_item = inv_mac_item::leftjoin('inv_supplier_invoice_item','inv_supplier_invoice_item.id','=','inv_mac_item.invoice_item_id')
                                 ->leftJoin('inv_lot_allocation','inv_lot_allocation.si_invoice_item_id','=','inv_supplier_invoice_item.id')
                                 ->leftjoin('inv_miq_item','inv_miq_item.invoice_item_id','=','inv_supplier_invoice_item.id')
                                 ->where('inv_lot_allocation.id','=',$request->lot_id)
                                 ->select('inv_mac_item.id','inv_mac_item.pr_item_id','inv_mac_item.accepted_quantity')->first();                   
            
            // $inv_mac_item->available_qty = 0;
            // $inv_mac_item->save();

            $stock = inv_stock_management::where('lot_id','=',$request->lot_id)->first();
            // $stockQty = $stock->stock_qty - array_sum($request->qty_to_production);
            $stockQty = $stock->stock_qty - $request->qty_to_production;
            $stock->stock_qty = $stockQty;
            $stock->save();
            if($mac_item)
            {
                $inv_mac_item = inv_mac_item::where('id',$mac_item['id'])->first();
                $ys1[]= inv_mac_item::where('id','=',$mac_item['id'])->decrement('available_qty',$request->qty_to_production);
                $data['pr_item_id'] = $inv_mac_item['pr_item_id'];
                $data['mac_item_id'] = $mac_item['id'];
            }  
           
            $data['stock_id']=$stock['id'];
            $sip_master = $this->inv_stock_to_production->insert_data($data);
            if($sip_master)
            { 
                //$row_material_id = inv_purchase_req_item::where('requisition_item_id','=',$inv_mac_item['pr_item_id'])->pluck('inv_purchase_req_item.item_code')->first();

                $info['lot_id'] =$request->lot_id;
                $info['item_id'] = $stock['item_id'];
                $info['transaction_type'] = 3;
                $info['transaction_id'] = $sip_master;
                // $info['transaction_qty'] = array_sum($request->qty_to_production);
                $info['transaction_qty'] = $request->qty_to_production;
                $info['created_at'] = date('Y-m-d H:i:s');
                $transaction = $this->inv_stock_transaction->insert_data($info);
    
                
                $item['mac_item_id'] = $request->mac_item_id;
                $item['material_id']=$request->item_code;
                $item['qty_to_production'] = $request->qty_to_production;
                $sip_item = $this->inv_stock_to_production_item->insert_data($item);

                // $inv_mac_item = inv_mac_item::where('id',$request->mac_item_id)->first();
                // $inv_mac_item->available_qty = $inv_mac_item->available_qty - $request->qty_to_production;
                // $inv_mac_item->save();

                $rel['master'] = $sip_master;
                $rel['item'] = $sip_item;
                DB::table('inv_stock_to_production_item_rel')->insert($rel);
               
                $request->session()->flash('success', "You have successfully added Stock issue to production !");
            }
            else
            {
                $request->session()->flash('error', "You have failed to add Stock issue to production !");
            }
            return redirect("inventory/Stock/ToProduction");

        }
        
    }

    function packingItem(Request $request,$itemcode = null){
        if(!$request->q){
            return response()->json(['message'=>'item code is not valid'], 500); 
        }
        $condition[] = ['inventory_rawmaterial.item_code','like','%'.strtoupper($request->q).'%'];
        $condition[] = ['inv_item_type_2.type_name','=','Packing Materials'];
        $data  = $this->inventory_rawmaterial->get_inv_raw_data($condition);
        if(!empty( $data)){
            return response()->json( $data, 200); 
        }else{
            return response()->json(['message'=>'item code is not valid'], 500); 
        }

    }

    public function DirectSIP()
    {
        //$this->removeExistOpenIndirectStock();
        //$this->removeExistOpenDirectStock();
       //$this->indirectupload();
        //$this->directupload();
        $work_centre = work_centre::where('status','=',1)->get();
        return view('pages.inventory.stock.direct-sip',compact('work_centre'));
    }
    public function fetchDeviationItemLotcards(Request $request)
    {
        $lotcards = inv_lot_allocation::select('inv_lot_allocation.id as lot_id','inv_lot_allocation.lot_number','inv_unit.unit_name','inventory_rawmaterial.item_code',
        'inv_stock_management.stock_qty','inv_stock_management.id as stock_id')
                                        ->leftJoin('inv_stock_management','inv_stock_management.lot_id','=','inv_lot_allocation.id')
                                        ->leftJoin('inventory_rawmaterial','inventory_rawmaterial.id','=','inv_stock_management.item_id')
                                        ->leftJoin('inv_unit', 'inv_unit.id','=', 'inventory_rawmaterial.issue_unit_id')
                                        ->where('inventory_rawmaterial.id','=', $request->item_id)
                                        ->where('inv_stock_management.stock_qty','!=',0)
                                        ->where('inv_stock_management.status','=',1)
                                        ->orderBy('inv_lot_allocation.id','asc')
                                        ->get();
                                        //return $lotcards;
        if(count($lotcards)>0)
        {
            $data = "<div style='color:#3366ff;font: size 15px;'><i class='fas fa-address-card' style='font-size:21px;'></i>&nbsp;<strong>LotCards</strong></div>
                        <div class='row'>
                            <div class='table-responsive'>
                                <table class='table table-bordered mg-b-0' id='example1' >
                                    <thead>
                                        <tr>
                                            <th></th>
                                            <th>LJotCard</th>
                                            <th>Item Code</th>
                                            <th>Quantity</th>
                                        </tr>
                                    </thead>
                                    <tbody>";
                                    $i=1;                                       
                                    foreach($lotcards as $card)
                                    {
                                        $data .="<tr>
                                                    <td><input type='radio' required class='lot-radio' name='lot_id' value='".$card->lot_id."' lotqty='".$card->stock_qty."' lotno='".$card->lot_number."' macItemid=".$card->stock_id."></td>
                                                    <th>".$card->lot_number."</th>
                                                    <th>".$card->item_code."</th>
                                                    <th>".$card->stock_qty." ".$card->unit_name."</th>
                                                </tr> ";                                               
                                        $i++;
                                    }
            $data .="<tbody></table></div></div>";
        }
        if($data)                               
        return $data;
        else
        return 0;
    }
    public function fetchBatchCards(Request $request)
    {
       // dd('hi');
        $data = []; // Initialize $data as an empty array
    
        $batchmaterials_in_sip_item = inv_stock_to_production_item::where('material_id', '=', $request->item_id)
            ->pluck('batchcard_material_id')
            ->toArray();
        $arr = array_filter($batchmaterials_in_sip_item);
    
        $batchcards = batchcard_material::select(
            'batchcard_materials.id as batchcard_material_id',
            'batchcard_batchcard.id as batchcard_id',
            'batchcard_batchcard.batch_no',
            'batchcard_materials.item_id',
            'batchcard_materials.quantity as material_qty',
            'batchcard_batchcard.quantity as sku_quantity',
            'product_product.sku_code',
            'inv_unit.unit_name'
        )
            ->leftJoin('batchcard_batchcard', 'batchcard_batchcard.id', '=', 'batchcard_materials.batchcard_id')
            ->leftJoin('product_product', 'batchcard_batchcard.product_id', '=', 'product_product.id')
            ->leftJoin('inventory_rawmaterial', 'inventory_rawmaterial.id', '=', 'batchcard_materials.item_id')
            ->leftJoin('inv_unit', 'inv_unit.id', '=', 'inventory_rawmaterial.issue_unit_id')
            ->whereNotIn('batchcard_materials.id', $arr)
            ->where('batchcard_batchcard.is_alloted', '=', 0)
            ->where('batchcard_batchcard.is_trade', '=', 0)
            ->where('batchcard_materials.item_id', '=', $request->item_id)
            ->orderBy('batchcard_batchcard.id', 'DESC')
            ->get();
   // dd($batchcards);
        $lotcards = inv_lot_allocation::select(
            'inv_lot_allocation.id as lot_id',
            'inv_lot_allocation.lot_number',
            'inv_unit.unit_name',
            'inventory_rawmaterial.item_code',
            'inv_stock_management.stock_qty',
            'inv_stock_management.id as stock_id'
        )
            ->leftJoin('inv_stock_management', 'inv_stock_management.lot_id', '=', 'inv_lot_allocation.id')
            ->leftJoin('inventory_rawmaterial', 'inventory_rawmaterial.id', '=', 'inv_stock_management.item_id')
            ->leftJoin('inv_unit', 'inv_unit.id', '=', 'inventory_rawmaterial.issue_unit_id')
            ->where('inventory_rawmaterial.id', '=', $request->item_id)
            ->where('inv_stock_management.stock_qty', '!=', 0)
            ->where('inv_stock_management.status', '=', 1)
            ->orderBy('inv_lot_allocation.id', 'asc')
            ->groupBy('inv_lot_allocation.id')
            ->get();
    
        $itemcode = inventory_rawmaterial::where('id', '=', $request->item_id)->pluck('item_code')->first();
    
        if (count($batchcards) > 0) {
            $data['batchcards'] = "<div style='color:#3366ff;font-size:15px;'>
                                        <i class='typcn typcn-tabs-outline' style='font-size:21px;'></i>&nbsp;<strong>BatchCards</strong>
                                    </div>
                                    <div class='row'>
                                        <div class='table-responsive'>
                                            <!-- Search Box -->
                                            <div class='mb-2'>
                                                <input type='text' id='batchcardSearch' class='form-control' placeholder='Search BatchCard, SKU...'>
                                            </div>
        
                                            <table class='table table-bordered mg-b-0' id='batchcardsTable'>
                                                <thead>
                                                    <tr>
                                                        <th></th>
                                                        <th>BatchCard</th>
                                                        <th>SKU Code</th>
                                                        <th>SKU Quantity</th>
                                                        <th>Item(" . $itemcode . ") Quantity Required</th>
                                                    </tr>
                                                </thead>
                                                <tbody>";
            foreach ($batchcards as $card) {
                $data['batchcards'] .= "<tr>
                                            <th><input type='checkbox' class='batchcard-checkbox' onclick='enableTextBox(this)' name='batchcard[]' value='" . $card->batchcard_id . "' batchqty='" . $card->material_qty . "'></th>
                                            <th>" . $card->batch_no . "</th>
                                            <th>" . $card->sku_code . "</th>
                                            <th>" . $card->sku_quantity . "</th>
                                            <th class='qty'>
                                                <span>" . $card->material_qty . " " . $card->unit_name . "</span>
                                            </th>
                                        </tr>";
            }
            $data['batchcards'] .= "</tbody>
                                        </table>
                                    </div>
                                </div><br/>";
        
            // Add search script
            $data['batchcards'] .= "<script>
                document.getElementById('batchcardSearch').addEventListener('keyup', function() {
                    var filter = this.value.toUpperCase();
                    var rows = document.querySelectorAll('#batchcardsTable tbody tr');
        
                    rows.forEach(function(row) {
                        var text = row.textContent.toUpperCase();
                        if (text.indexOf(filter) > -1) {
                            row.style.display = '';
                        } else {
                            row.style.display = 'none';
                        }
                    });
                });
            </script>";
        }
        
    
        if (count($lotcards) > 0) {
            $data['lotcards'] = "<div style='color:#3366ff;font: size 15px;'><i class='fas fa-address-card' style='font-size:21px;'></i>&nbsp;<strong>LotCards</strong></div>
                                    <div class='row'>
                                        <div class='table-responsive'>
                                            <table class='table table-bordered mg-b-0' id='example1'>
                                                <thead>
                                                <tr>
                                                    <th></th>
                                                    <th>LotCard</th>
                                                    <th>Item Code</th>
                                                    <th>Quantity</th>
                                                </tr>
                                                </thead>
                                                <tbody>";
            foreach ($lotcards as $card) {
                $data['lotcards'] .= "<tr>
                                        <td><input type='radio' required class='lot-radio' name='lot_id' value='" . $card->lot_id . "' lotqty='" . $card->stock_qty . "' lotno='" . $card->lot_number . "' macItemid=" . $card->stock_id . "></td>
                                        <th>" . $card->lot_number . "</th>
                                        <th>" . $itemcode . "</th>
                                        <th>" . $card->stock_qty . " " . $card->unit_name . "</th>
                                    </tr>";
            }
            $data['lotcards'] .= "</tbody></table></div></div>";
        }
    
        return !empty($data) ? $data : 0;
    }
    

    public function addDirectSIP(Request $request)
{
    // Validation rules
    $validation['lot_id'] = ['required'];
    $validation['batchcard'] = ['required'];
    $validation['work_centre'] = ['required'];
    $validation['qty_to_production'] = ['required'];
    $validator = Validator::make($request->all(), $validation);

    if(!$validator->fails())
    {
        // Determine year combo for SIP number
        $years_combo = (date('m') >= 1 && date('m') <= 3)
            ? date('y', strtotime('-1 year')).date('y')
            : date('y').date('y', strtotime('+1 year'));

        // Generate SIP number
        $data['sip_number'] = "SIP2-".$this->year_combo_num_gen_inv(
            DB::table('inv_stock_to_production')->where('sip_number', 'LIKE', 'SIP2-'.$years_combo.'%')->count()
        );

        // Retrieve lot data
        $lot_data = $this->inv_lot_allocation->get_single_lot1(['inv_lot_allocation.id' => $request->lot_id]);

        // Prepare data for insertion
        $data = [
            'sip_number' => $data['sip_number'],
            'lot_id' => $request->lot_id,
            'qty_to_production' => $request->qty_to_production,
            'type' => 2,
            'status' => 1,
            'work_centre' => $request->work_centre,
            'transaction_slip' => $request->transaction_slip,
            'deviation_item_code' => $request->deviation_item_code,
            'deviation_no' => $request->deviation_no,
            'created_at' => now(),
            'updated_at' => now(),
        ];

        // Retrieve stock management data
        $stock = inv_stock_management::where('lot_id', $request->lot_id)->first();
        if (!$stock) {
            $request->session()->flash('error', "Stock not found.");
            return redirect("inventory/Stock/ToProduction/Direct");
        }

        // Check if qty_to_production exceeds stock_qty
        if ($request->qty_to_production > $stock->stock_qty) {
            $request->session()->flash('error', "The quantity to be produced exceeds the available stock.");
            return redirect("inventory/Stock/ToProduction/Direct")->withInput();
        }

        // Update stock quantity
        $stock->stock_qty -= $request->qty_to_production;
        $stock->save();

        // Retrieve MAC item
        $mac_item = inv_mac_item::leftjoin('inv_supplier_invoice_item', 'inv_supplier_invoice_item.id', '=', 'inv_mac_item.invoice_item_id')
            ->leftJoin('inv_lot_allocation', 'inv_lot_allocation.si_invoice_item_id', '=', 'inv_supplier_invoice_item.id')
            ->leftjoin('inv_miq_item', 'inv_miq_item.invoice_item_id', '=', 'inv_supplier_invoice_item.id')
            ->where('inv_lot_allocation.id', $request->lot_id)
            ->select('inv_mac_item.id', 'inv_mac_item.pr_item_id', 'inv_mac_item.accepted_quantity')
            ->first();

        if ($mac_item) {
            // Update available quantity for MAC item
            inv_mac_item::where('id', $mac_item->id)->decrement('available_qty', $request->qty_to_production);
            $data['pr_item_id'] = $mac_item->pr_item_id;
            $data['mac_item_id'] = $mac_item->id;
        }

        // Insert stock to production record
        $data['stock_id'] = $stock->id;
        $sip_master = $this->inv_stock_to_production->insert_data($data);

        if ($sip_master) {
            // Insert stock transaction record
            $info = [
                'lot_id' => $request->lot_id,
                'item_id' => $stock->item_id,
                'transaction_type' => 3,
                'transaction_id' => $sip_master,
                'transaction_qty' => $request->qty_to_production,
                'created_at' => now(),
            ];
            $this->inv_stock_transaction->insert_data($info);

            // Insert stock to production item records
            foreach ($request->batchcard as $i => $batchcard) {
                $batchdata = batchcard_material::where('batchcard_id', $batchcard)
                    ->where('item_id', $request->item_code)
                    ->first();
                
                $batch = [
                    'batchcard_id' => $batchcard,
                    'batchcard_material_id' => $batchdata->id,
                    'material_id' => $request->item_code,
                ];

                $sip_item = $this->inv_stock_to_production_item->insert_data($batch);
                $rel = [
                    'master' => $sip_master,
                    'item' => $sip_item,
                ];
                DB::table('inv_stock_to_production_item_rel')->insert($rel);
            }

            // Flash success message and redirect
            $request->session()->flash('success', "You have successfully added Stock issue to production!");
            return redirect("inventory/Stock/ToProduction/Direct");
        } else {
            // Flash error message and redirect
            $request->session()->flash('error', "You have failed to add Stock issue to production!");
            return redirect("inventory/Stock/ToProduction/Direct");
        }
    }

    // Redirect with validation errors
    return redirect("inventory/Stock/ToProduction/Direct")->withErrors($validator)->withInput();
}

    public function IndirectSIP()
    {
        $work_centre = work_centre::where('status','=',1)->get();
        return view('pages.inventory.stock.indirect-sip',compact('work_centre')); 
    }
    public function addIndirectSIP(Request $request)
    {
        $validation['transaction_slip'] = ['required'];
        $validation['item_code'] = ['required'];
        $validation['qty_to_production'] = ['required'];
        $validation['work_centre'] = ['required'];
        $validator = Validator::make($request->all(), $validation);
        if(!$validator->errors()->all())
        {
            if(date('m')==01 || date('m')==02 || date('m')==03)
            {
                $years_combo = date('y', strtotime('-1 year')).date('y');
            }
            else
            {
                $years_combo = date('y').date('y', strtotime('+1 year'));
            }
            $data['sip_number'] = "SIP3-".$this->year_combo_num_gen_inv(DB::table('inv_stock_to_production')->where('inv_stock_to_production.sip_number', 'LIKE', 'SIP3-'.$years_combo.'%')->count()); 

            $data['transaction_slip'] = $request->transaction_slip;
            $data['type'] = 3;
            $data['status'] = 1;
            $data['created_by']= config('user')['user_id'];
            $data['created_at']= date('Y-m-d H:i:s');
            $data['updated_at']= date('Y-m-d H:i:s');
           // $transaction = $this->inv_stock_transaction->insert_data($info);
            $data['qty_to_production'] = $request->qty_to_production;
            $mac_items = inv_mac_item::leftJoin('inv_purchase_req_item','inv_purchase_req_item.requisition_item_id','=','inv_mac_item.pr_item_id')
                                        //->leftJoin('','','=','inv_purchase_req_item.Item_code')
                                        ->where('id',$request->mac_item_id)->first();
        //    // echo $mac_item->mac_item_id;exit;
        //    if($mac_item)
        //     $data['pr_item_id'] = $mac_item['pr_item_id'];
        //     $data['mac_item_id'] = $request->mac_item_id;
            $data['stock_id'] = $request->stock_id;
            $data['work_centre'] = $request->work_centre;
            $sip_master = $this->inv_stock_to_production->insert_data($data);

            $stock = inv_stock_management::where('id','=',$request->stock_id)->first();
            $stock_qty = $stock->stock_qty - $request->qty_to_production;
            $stock->stock_qty = $stock_qty;
            $stock->save();
            
            if($sip_master)
            {
                
                $inf['item_id'] = $stock['item_id'];
                $inf['transaction_type'] = 3;
                $inf['transaction_id'] = $sip_master;
                $inf['transaction_qty'] = $request->qty_to_production;
                $inf['created_at'] = date('Y-m-d H:i:s');
                $transaction = $this->inv_stock_transaction->insert_data($inf);

                $item['mac_item_id'] = $request->mac_item_id;
                $item['material_id']=$request->item_code;
                $item['qty_to_production'] = $request->qty_to_production;
                $sip_item = $this->inv_stock_to_production_item->insert_data($item);

                // $inv_mac_item = inv_mac_item::where('id',$request->mac_item_id)->first();
                // $inv_mac_item->available_qty = $inv_mac_item->available_qty - $request->qty_to_production;
                // $inv_mac_item->save();

                $rel['master'] = $sip_master;
                $rel['item'] = $sip_item;
                DB::table('inv_stock_to_production_item_rel')->insert($rel);
                $request->session()->flash('success', "You have successfully added Stock issue to production !");
            }
            else
            {
                $request->session()->flash('error', "You have failed to add Stock issue to production !");
            }
            return redirect("inventory/Stock/ToProduction");
        }
        if($validator->errors()->all())
        {
            //$request->session()->flash('error', "Stock transfer order updation failed!");
            return redirect("inventory/ToProduction/Indirect")->withErrors($validator)->withInput();
        }
    }

    public function itemMacDetails(Request $request)
    {
        $mac_details = inv_mac_item::select('inv_mac.mac_number','inv_mac_item.accepted_quantity','inv_mac_item.available_qty','inv_unit.unit_name','inv_mac_item.id as mac_item_id')
                        ->leftJoin('inv_mac_item_rel','inv_mac_item_rel.item','=','inv_mac_item.id')
                        ->leftJoin('inv_mac','inv_mac.id','=','inv_mac_item_rel.master')
                        ->leftJoin('inv_purchase_req_item','inv_purchase_req_item.requisition_item_id','=','inv_mac_item.pr_item_id')
                        ->leftJoin('inventory_rawmaterial','inventory_rawmaterial.id','=','inv_purchase_req_item.Item_code')
                        ->leftjoin('inv_unit', 'inv_unit.id','=', 'inventory_rawmaterial.issue_unit_id')
                        ->where('inv_purchase_req_item.Item_code','=', $request->item_id)
                        ->where('inventory_rawmaterial.item_type_id','!=',2 )
                        ->where('inv_mac_item.available_qty','!=',0 )
                        ->first();
        return $mac_details;
        
    }
    public function itemStockDetails(Request $request)
    {
        $stock_info = inv_stock_management::select('inv_stock_management.id as stock_id','inv_stock_management.stock_qty','inv_unit.unit_name')
                        ->leftJoin('inventory_rawmaterial','inventory_rawmaterial.id','=','inv_stock_management.item_id')
                        ->leftjoin('inv_unit', 'inv_unit.id','=', 'inventory_rawmaterial.issue_unit_id')
                        ->where('inv_stock_management.item_id','=', $request->item_id)
                        ->where('inv_stock_management.stock_qty','!=', 0)
                        ->first();
        return $stock_info;
    }

    public function StockToProduction(Request $request)
    {
        $condition = [];
        if($request)
        {
            if ($request->sip_number) {
                $condition[] = ['inv_stock_to_production.sip_number','like', '%' . $request->sip_number . '%'];
            }
            if ($request->lot_number) {
                $condition[] = ['inv_lot_allocation.lot_number','like', '%' . $request->lot_number . '%'];
            }
            if ($request->item_code) {
                $condition[] = ['inventory_rawmaterial.item_code','like', '%' . $request->item_code . '%'];
            }
            if($request->supplier)
            {
                $condition[] = [DB::raw("CONCAT(inv_supplier.vendor_id,' - ',inv_supplier.vendor_name)"), 'like', '%' . $request->supplier . '%'];
            }
           
        }
        $data['sip'] =$this->inv_stock_to_production->get_all_data($condition);
        foreach($data['sip'] as $sip)
        {
            $sip['items']=inv_stock_to_production_item::select('batchcard_batchcard.batch_no','inv_stock_to_production_item.qty_to_production')
                                        ->leftJoin('batchcard_batchcard','batchcard_batchcard.id','=','inv_stock_to_production_item.batchcard_id')
                                        ->leftJoin('inv_stock_to_production_item_rel','inv_stock_to_production_item_rel.item','=','inv_stock_to_production_item.id')
                                        ->where('inv_stock_to_production_item_rel.master','=',$sip['id'])
                                        ->get();
        }
        return view('pages.inventory.stock.stock-issue-to-production',compact('data'));
    }

    // public function returnFromProduction(Request $request)
    // {
    //    // echo "kk";exit;
    //     $validation['batch_card'] = ['required'];
    //     $validation['item_id'] = ['required'];
    //     $validation['qty_return'] = ['required'];
    //     $validator = Validator::make($request->all(), $validation);
    //     if(!$validator->errors()->all())
    //     {
    //         // foreach($request->sip_id as $sip_id)
    //         // {
    //         //     //$lot_data = $this->inv_lot_allocation->get_single_lot1(['inv_lot_allocation.id'=>$lot_id]);
    //         //     $sip_data = inv_stock_to_production::select('*')->where('id','=',$sip_id)->first();
    //         //    // print_r(json_encode($lot_data));exit;
    //         //     $item_type = $this->get_item_type($sip_data['pr_item_id']);
    //         //     if($item_type=="Direct Items")
    //         //     {
    //         //         $data['sir_number'] = "SIR2-".$this->po_num_gen(DB::table('inv_stock_from_production')->where('inv_stock_from_production.sir_number', 'LIKE', 'SIR2%')->count(),1); 
    //         //     }
    //         //     if($item_type=="Indirect Items")
    //         //     {
    //         //         $data['sir_number'] = "SIR3-" . $this->po_num_gen(DB::table('inv_stock_from_production')->where('inv_stock_from_production.sir_number', 'LIKE', 'SIR3%')->count(),1); 
    //         //     }
    //         //     // $mac_qty = $this->get_mac_qty($mac_item_data['invoice_item_id']);
    //         //     // if($mac_qty)
    //         //     // $data['quantity']=$mac_qty;
    //         //     // else
    //         //     $data['quantity']=$sip_data['quantity'];
    //         //     $data['lot_id']= $sip_data['lot_id'];
    //         //     $data['pr_item_id']= $sip_data['pr_item_id'];
    //         //     $data['sip_id']=$sip_data['id'];
    //         //     $data['status']= 1;
    //         //     $data['created_at']= date('Y-m-d H:i:s');
    //         //     $data['updated_at']= date('Y-m-d H:i:s');
    //         //     $add[] = $this->inv_stock_from_production->insert_data($data);

    //         // }
    //         // if(count($add)==count($request->sip_id))
    //         $item_type=$this->get_item_type($request->item_id);
    //         if($item_type=="Direct Items")
    //         {
    //             $data['sir_number'] = "SIR2-".$this->po_num_gen(DB::table('inv_stock_from_production')->where('inv_stock_from_production.sir_number', 'LIKE', 'SIR2%')->count(),1); 
    //         }
    //         //if($item_type=="Indirect Items")
    //         else
    //         {
    //             $data['sir_number'] = "SIR3-" . $this->po_num_gen(DB::table('inv_stock_from_production')->where('inv_stock_from_production.sir_number', 'LIKE', 'SIR3%')->count(),1); 
    //         }
    //         $data['lot_id']= $request->lotcard_id;
    //         $data['item_id'] = $request->item_id;
    //         $data['batch_id'] = $request->batch_card;
    //         $data['qty_to_return']= $request->qty_return;
    //         $data['status']= 1;
    //         $data['created_at']= date('Y-m-d H:i:s');
    //         $data['updated_at']= date('Y-m-d H:i:s');
           
            
    //         $mac_item = inv_lot_allocation::select('inv_mac_item.id as mac_item_id','inv_mac_item.available_qty','inv_lot_allocation.pr_item_id','inv_lot_allocation.lot_number')
    //                                 ->leftJoin('inv_supplier_invoice_item','inv_supplier_invoice_item.id','=','inv_lot_allocation.si_invoice_item_id')
    //                                 ->leftJoin('inv_miq_item','inv_miq_item.lot_number','=','inv_lot_allocation.lot_number')
    //                                 ->leftJoin('inv_mac_item','inv_mac_item.invoice_item_id','=','inv_lot_allocation.si_invoice_item_id')
    //                                 ->where('inv_lot_allocation.id','=',$request->lotcard_id)
    //                                 ->first();

    //         $data['pr_item_id'] =  $mac_item['pr_item_id'];
    //         $data['mac_item_id'] = $mac_item['mac_item_id'];
    //         $add =$this->inv_stock_from_production->insert_data($data);

    //         $update_qty = $mac_item['available_qty']+$request->qty_return;
    //         $qty_update =$this->inv_mac_item->update_data(['inv_mac_item.id'=>$mac_item['mac_item_id']],['inv_mac_item.available_qty'=>$update_qty]);

    //         if($add && $qty_update)
    //         $request->session()->flash('success', "You have successfully added Stock return from production !");
    //         else
    //         $request->session()->flash('error', "You have failed to add Stock return from production !");
    //         return redirect("inventory/Stock/FromProduction");
    //     }
    //     if($validator->errors()->all())
    //     {
    //         $request->session()->flash('error', "You have failed to add Stock return from production !");
    //         return redirect("inventory/Stock/FromProduction-add");
    //     }

    // }

    public function quantityUpdationRequest(Request $request)
    {
        $is_exist = inv_batchcard_qty_updation_request::where('item_id','=',$request->item_id)
                                    ->where('batchcard_id','=',$request->batch_id)
                                    ->where('sku_qty_to_be_update','=', $request->request_sku_qty)
                                    ->where('material_qty_to_be_update','=', $request->request_qty)
                                    ->where('status','!=',0)
                                    ->exists();
        if($is_exist)
        {
            $request->session()->flash('error', "The request already exist !");
            return redirect()->back();
        }   
        {    
            $data['item_id'] = $request->item_id;
            $data['batchcard_id'] = $request->batch_id;
            $data['batchcard_material_id'] = $request->batchcard_material_id;
            $data['sku_qty_to_be_update']= $request->request_sku_qty;
            $data['material_qty_to_be_update']= $request->request_qty;
            $data['status']= 2;
            $data['created_at']= date('Y-m-d H:i:s');
            $data['updated_at']= date('Y-m-d H:i:s');
            $add =$this->inv_batchcard_qty_updation_request->insert_data($data);
            $request->session()->flash('success', "You have successfully send a quantity updation request !");
            return redirect()->back();
        }
    }

    function Indirectitemcodesearch(Request $request,$itemcode = null){
        if(!$request->q){
            return response()->json(['message'=>'item code is not valid'], 500); 
        }
        $condition[] = ['inventory_rawmaterial.item_code','like','%'.strtoupper($request->q).'%'];
        $condition[] = ['inventory_rawmaterial.item_type_id','!=',2];
        $data  = $this->inventory_rawmaterial->get_inv_raw_data($condition);
        if(!empty( $data)){
            return response()->json( $data, 200); 
        }else{
            return response()->json(['message'=>'item code is not valid'], 500); 
        }

    }

    function Directitemcodesearch(Request $request,$itemcode = null)
    {
        if(!$request->q){
            return response()->json(['message'=>'item code is not valid'], 500); 
        }
        $condition[] = ['inventory_rawmaterial.item_code','like','%'.strtoupper($request->q).'%'];
        $condition[] = ['inventory_rawmaterial.item_type_id','=',2];
        $data  = $this->inventory_rawmaterial->get_inv_raw_data($condition);
        if(!empty( $data)){
            return response()->json( $data, 200); 
        }else{
            return response()->json(['message'=>'item code is not valid'], 500); 
        }
    }

    function getItem_SIPIndirect($sip_id)
    {
        $item = inv_stock_to_production_item::Join('inv_stock_to_production_item_rel','inv_stock_to_production_item_rel.item','=','inv_stock_to_production_item.id')
                                            ->Join('inventory_rawmaterial','inventory_rawmaterial.id','=','inv_stock_to_production_item.material_id')
                                            ->leftjoin('inv_unit', 'inv_unit.id','=', 'inventory_rawmaterial.issue_unit_id')
                                            ->where('inv_stock_to_production_item_rel.master','=',$sip_id)
                                            ->select('inventory_rawmaterial.item_code','inv_unit.unit_name','inventory_rawmaterial.discription')
                                            ->first();
        return $item ;
    }

    public function SIPview($id)
    {
        $sip = $this->inv_stock_to_production->get_single_data(['inv_stock_to_production.id'=>$id]);
        $sip['items']=inv_stock_to_production_item::select('batchcard_batchcard.batch_no','inv_stock_to_production_item.qty_to_production')
                    ->leftJoin('batchcard_batchcard','batchcard_batchcard.id','=','inv_stock_to_production_item.batchcard_id')
                    ->leftJoin('inv_stock_to_production_item_rel','inv_stock_to_production_item_rel.item','=','inv_stock_to_production_item.id')
                    ->where('inv_stock_to_production_item_rel.master','=',$sip['id'])
                    ->get();
        //print_r($sip);exit;
        if($sip['type']==2)//direct
        {
            return view('pages.inventory.stock.sip-direct-view',compact('sip'));
        }
        else
        {
            return view('pages.inventory.stock.sip-indirect-view',compact('sip'));
        }
    }

    /*public function fetchSIPinfoDirect(Request $request)
    {
        $data['sip'] = inv_stock_to_production::select('inv_stock_to_production.id as sip_id','inv_mac.mac_number','inv_stock_to_production.sip_number',
        'inv_lot_allocation.lot_number','inv_lot_allocation.id as lotcard_id','inv_stock_to_production.mac_item_id')
                    ->leftJoin('inv_purchase_req_item','inv_purchase_req_item.requisition_item_id','=','inv_stock_to_production.pr_item_id')
                    ->leftJoin('inv_mac_item','inv_mac_item.id','=','inv_stock_to_production.mac_item_id')
                    ->leftjoin('inv_mac_item_rel','inv_mac_item_rel.item','=','inv_stock_to_production.mac_item_id')
                    ->leftJoin('inv_mac','inv_mac.id','=','inv_mac_item_rel.master')
                    //->leftJoin('inv_stock_to_production','inv_stock_to_production.mac_item_id','=','inv_mac_item.id')
                    ->leftjoin('inv_lot_allocation','inv_lot_allocation.id','=','inv_stock_to_production.lot_id')
                    ->whereNotIn('inv_stock_to_production.id',function($query) {

                        $query->select('inv_stock_from_production.sip_id')->from('inv_stock_from_production');
                    
                    })
                    ->where('inv_purchase_req_item.Item_code','=', $request->row_material_id)
                    ->first();
        if($data['sip'])
        {
        $data['batchcards'] = inv_stock_to_production_item::select('batchcard_batchcard.id as batchcard_id','batchcard_batchcard.batch_no','inv_stock_to_production_item.qty_to_production')
                        ->leftJoin('batchcard_batchcard','batchcard_batchcard.id','=','inv_stock_to_production_item.batchcard_id')
                        ->leftJoin('inv_stock_to_production_item_rel','inv_stock_to_production_item_rel.item','=','inv_stock_to_production_item.id')
                        ->where('inv_stock_to_production_item_rel.master','=', $data['sip']['sip_id'])
                        ->where('inv_stock_to_production_item.material_id','=',$request->row_material_id)
                        ->get();
        }
        return $data;
       // echo $request->row_material_id;

    }*/

    public function fetchDirectItemLotCards(Request $request)
    {
        $lotcards = inv_stock_to_production::select('inv_lot_allocation.id','inv_lot_allocation.lot_number')
                            ->leftjoin('inv_lot_allocation','inv_lot_allocation.id','=','inv_stock_to_production.lot_id')
                            ->leftjoin('inv_stock_management','inv_stock_management.id','=','inv_stock_to_production.stock_id')
                            ->whereNotIn('inv_stock_to_production.id',function($query) {

                                $query->select('inv_stock_from_production.sip_id')->from('inv_stock_from_production');
                            
                            })
                            ->where('inv_stock_management.item_id','=',$request->row_material_id)
                            ->get();
        return $lotcards;
    
    }
    public function lotcardInfo(Request $request)
    {
        $data['sip'] = inv_stock_to_production::where('lot_id','=',$request->lot_id)->select('sip_number','id')->first();
        $data['batchcards'] = inv_stock_to_production_item::select('batchcard_batchcard.id as batchcard_id','batchcard_batchcard.batch_no','inv_stock_to_production_item.qty_to_production')
                                                ->leftJoin('batchcard_batchcard','batchcard_batchcard.id','=','inv_stock_to_production_item.batchcard_id')
                                                ->leftJoin('inv_stock_to_production_item_rel','inv_stock_to_production_item_rel.item','=','inv_stock_to_production_item.id')
                                                ->leftJoin('inv_stock_to_production','inv_stock_to_production.id','=','inv_stock_to_production_item_rel.master')
                                                ->where('inv_stock_to_production.lot_id','=',$request->lot_id)
                                                ->get();
        return $data;

    }


    public function fetchSIPinfoIndirect(Request $request)
    {
        $data = inv_stock_to_production::select('inv_stock_to_production.id as sip_id','inv_stock_to_production.sip_number',
        'inv_stock_to_production.qty_to_production')
                    ->leftjoin('inv_stock_management','inv_stock_management.id','=','inv_stock_to_production.stock_id')
                    ->whereNotIn('inv_stock_to_production.id',function($query) {

                        $query->select('inv_stock_from_production.sip_id')->from('inv_stock_from_production');
                    
                    })
                    ->where('inv_stock_management.item_id','=', $request->row_material_id)
                    ->get();
        return $data;
    }
    public function returnFromProductionAdd(Request $request)
    {
        if($request->item_type=="Direct Items")
        {
            $validation['item_code'] = ['required'];
            $validation['lotcard'] = ['required'];
            //$validation['mac_item_id'] = ['required'];
            $validation['sip_id'] = ['required'];
            $validation['batchcard'] = ['required'];
            $validation['return_qty'] = ['required'];
            $validator = Validator::make($request->all(), $validation);
            if(!$validator->errors()->all())
            {
                if(date('m')==01 || date('m')==02 || date('m')==03)
                {
                    $years_combo = date('y', strtotime('-1 year')).date('y');
                }
                else
                {
                    $years_combo = date('y').date('y', strtotime('+1 year'));
                }
                $mac_item = inv_mac_item::leftjoin('inv_supplier_invoice_item','inv_supplier_invoice_item.id','=','inv_mac_item.invoice_item_id')
                                    ->leftJoin('inv_lot_allocation','inv_lot_allocation.si_invoice_item_id','=','inv_supplier_invoice_item.id')
                                    ->leftjoin('inv_miq_item','inv_miq_item.invoice_item_id','=','inv_supplier_invoice_item.id')
                                    ->where('inv_lot_allocation.id','=',$request->lot_id)
                                    ->select('inv_mac_item.id','inv_mac_item.pr_item_id','inv_mac_item.accepted_quantity')->first();       
                $data['sir_number'] = "SIR2-".$this->year_combo_num_gen_inv(DB::table('inv_stock_from_production')->where('inv_stock_from_production.sir_number', 'LIKE', 'SIR2-'.$years_combo.'%')->count());
                $data['lot_id']= $request->lotcard;
                $data['item_id'] = $request->item_code;
                $data['batch_id'] = $request->batchcard;
                $data['qty_to_return']= $request->return_qty;
                $data['sip_id']= $request->sip_id;
                $data['stock_id'] = inv_stock_to_production::where('id','=',$request->sip_id)->pluck('stock_id')->first();
                $data['status']= 1;
                $data['created_at']= date('Y-m-d H:i:s');
                $data['updated_at']= date('Y-m-d H:i:s');
                if($mac_item)
                {
                    $data['mac_item_id'] = $mac_item['id'];
                    $data['pr_item_id'] = $mac_item['pr_item_id'];
                    $ys1[]= inv_mac_item::where('id','=',$mac_item['id'])->increment('available_qty',$request->return_qty);
                    
                }
                $sir_add =$this->inv_stock_from_production->insert_data($data);     

                $stock = inv_stock_management::where('id','=',$data['stock_id'])->first();
                $stock_qty = $stock->stock_qty + $request->return_qty;
                $stock->stock_qty = $stock_qty;
                $stock->save();

                $inf['item_id'] = $stock['item_id'];
                $inf['transaction_type'] = 4;
                $inf['transaction_id'] = $sir_add;
                $inf['lot_id'] = $request->lotcard;
                $inf['transaction_qty'] = $request->return_qty;
                $inf['created_at'] = date('Y-m-d H:i:s');
                $transaction = $this->inv_stock_transaction->insert_data($inf);
              
                // $data['pr_item_id'] =  $mac_item['pr_item_id'];
                // $data['mac_item_id'] = $request->mac_item_id;
                // $mac_item = inv_mac_item::where('id',$request->mac_item_id)->first();
                // $update_qty = $mac_item['available_qty']+$request->return_qty;
                // $qty_update =$this->inv_mac_item->update_data(['inv_mac_item.id'=>$mac_item['id']],['inv_mac_item.available_qty'=>$update_qty]);
                if($sir_add && $transaction)
                    $request->session()->flash('success', "You have successfully added Stock return from production !");
                else
                    $request->session()->flash('error', "You have failed to add Stock return from production !");
                return redirect("inventory/Stock/FromProduction-add");
            }
            if($validator->errors()->all())
            {
                //$request->session()->flash('error', "You have failed to add Stock return from production !");
                return redirect("inventory/Stock/FromProduction-add")->withErrors($validator)->withInput();
            }
        }
        else
        {
            $validation['item_code'] = ['required'];
           // $validation['mac_item_id1'] = ['required'];
            $validation['sipnumber'] = ['required'];
            $validation['return_quantity'] = ['required'];
            $validator = Validator::make($request->all(), $validation);
            if(!$validator->errors()->all())
            {
                if(date('m')==01 || date('m')==02 || date('m')==03)
                {
                    $years_combo = date('y', strtotime('-1 year')).date('y');
                }
                else
                {
                    $years_combo = date('y').date('y', strtotime('+1 year'));
                }
                $data['sir_number'] = "SIR3-".$this->year_combo_num_gen_inv(DB::table('inv_stock_from_production')->where('inv_stock_from_production.sir_number', 'LIKE', 'SIR3-'.$years_combo.'%')->count());
                $data['item_id'] = $request->item_code;
                $data['qty_to_return']= $request->return_quantity;
                $data['status']= 1;
                $data['created_at']= date('Y-m-d H:i:s');
                $data['updated_at']= date('Y-m-d H:i:s');
                $data['sip_id']= $request->sipnumber;    
                $data['stock_id'] = inv_stock_to_production::where('id','=',$request->sipnumber)->pluck('stock_id')->first(); 
                // $mac_item = inv_mac_item::where('id',$request->mac_item_id1)->first();
                // $data['pr_item_id'] =  $mac_item['pr_item_id'];
                // $data['mac_item_id'] = $request->mac_item_id1;
                $sir_add =$this->inv_stock_from_production->insert_data($data);
                // $update_qty = $mac_item['available_qty']+$request->return_quantity;
                // $qty_update =$this->inv_mac_item->update_data(['inv_mac_item.id'=>$mac_item['id']],['inv_mac_item.available_qty'=>$update_qty]);
                $stock = inv_stock_management::where('id','=',$data['stock_id'])->first();
                $stock_qty = $stock->stock_qty + $request->return_quantity;
                $stock->stock_qty = $stock_qty;
                $stock->save();

                $inf['item_id'] = $stock['item_id'];
                $inf['transaction_type'] = 4;
                $inf['transaction_id'] = $sir_add;
                $inf['transaction_qty'] = $request->return_quantity;
                $inf['created_at'] = date('Y-m-d H:i:s');
                $transaction = $this->inv_stock_transaction->insert_data($inf);

                if($sir_add && $transaction)
                    $request->session()->flash('success', "You have successfully added Stock return from production !");
                else
                    $request->session()->flash('error', "You have failed to add Stock return from production !");
                return redirect("inventory/Stock/FromProduction-add");
            }
            if($validator->errors()->all())
            {
                //$request->session()->flash('error', "You have failed to add Stock return from production !");
                return redirect("inventory/Stock/FromProduction-add")->withErrors($validator)->withInput();
            }
        }
    }

    public function StockTransfer(Request $request)
    {
        $condition = [];
        // if($request)
        // {
        //     if ($request->sto_number) {
        //         $condition[] = ['inv_stock_transfer_order.sto_number','like', '%' . $request->sto_number . '%'];
        //     }
        //     if ($request->lot_number) {
        //         $condition[] = ['inv_lot_allocation.lot_number','like', '%' . $request->lot_number . '%'];
        //     }
        //     if ($request->item_code) {
        //         $condition[] = ['inventory_rawmaterial.item_code','like', '%' . $request->item_code . '%'];
        //     }
        //     if($request->supplier)
        //     {
        //         $condition[] = [DB::raw("CONCAT(inv_supplier.vendor_id,' - ',inv_supplier.vendor_name)"), 'like', '%' . $request->supplier . '%'];
        //     }
           
        // }
        $data['sto'] =$this->inv_stock_transfer_order->get_all_data($condition);
        return view('pages.inventory.stock.stock-transfer', compact('data'));
    }
    public function viewSTOItems($sto_id)
    {
        $data['sto'] = inv_stock_transfer_order::where('id','=',$sto_id)->first();
        $data['items'] = inv_stock_transfer_order_item::select('inventory_rawmaterial.item_code','inv_unit.unit_name','inv_stock_transfer_order_item.transfer_qty',
        'inv_stock_transfer_order_item.transfer_reason','inv_lot_allocation.lot_number')
                ->leftjoin('inventory_rawmaterial','inventory_rawmaterial.id','=','inv_stock_transfer_order_item.item_id')
                ->leftjoin('inv_unit', 'inv_unit.id','=', 'inventory_rawmaterial.issue_unit_id')
                ->leftJoin('inv_lot_allocation','inv_lot_allocation.id','=','inv_stock_transfer_order_item.lot_id')
                ->leftjoin('inv_stock_transfer_order_item_rel', 'inv_stock_transfer_order_item_rel.item','=', 'inv_stock_transfer_order_item.id')
                ->where('inv_stock_transfer_order_item_rel.master','=',$sto_id)
                ->orderBy('inv_stock_transfer_order_item.id','desc')
                ->paginate(15);
        return view('pages.inventory.stock.stock-transfer-items', compact('data'));
    }

    public function StockTransferAdd(Request $request)
    {
        return view('pages.inventory.stock.stock-transfer-add');
    }

    public function item_qty_in_mac(Request $request)
    {
        if ($request->q) {
            $condition[] = ['inventory_rawmaterial.item_code', 'like', '%' . strtoupper($request->q) . '%'];
            // $data = inv_mac_item::select('inventory_rawmaterial.id as id','inventory_rawmaterial.item_code as text','inventory_rawmaterial.discription','inv_unit.unit_name')
            //             ->leftjoin('inv_purchase_req_item','inv_purchase_req_item.requisition_item_id','=','inv_mac_item.pr_item_id')
            //             ->leftjoin('inventory_rawmaterial','inventory_rawmaterial.id','=','inv_purchase_req_item.Item_code')
            //             ->leftjoin('inv_mac_item_rel','inv_mac_item_rel.item','=','inv_mac_item.id')
            //             ->leftjoin('inv_mac','inv_mac.id','=','inv_mac_item_rel.master')
            //             ->leftjoin('inv_unit','inv_unit.id','=','inventory_rawmaterial.receipt_unit_id')
            //             ->where('inv_mac.status','=',1)
            //             ->where($condition)
            //             ->get()->toArray();
            $data = inv_stock_management::select('inventory_rawmaterial.id as id','inventory_rawmaterial.item_code as text','inventory_rawmaterial.discription','inv_unit.unit_name',
            'inv_stock_management.stock_qty','inv_item_type.type_name')
                            ->leftjoin('inventory_rawmaterial','inventory_rawmaterial.id','=','inv_stock_management.item_id')
                            ->leftjoin('inv_unit','inv_unit.id','=','inventory_rawmaterial.receipt_unit_id')
                            ->leftjoin('inv_item_type','inv_item_type.id','=','inventory_rawmaterial.item_type_id')
                            ->where($condition)
                            ->where('inv_stock_management.stock_qty','!=',0)
                            ->get()->toArray();


            if (!empty($data[0])) {
                return response()->json($data, 200);
            } else {
                return response()->json(['message' => 'item code is not valid'], 500);
            }
        } 
        
       // return $item;
    }

    public function fetchLotCard_for_sto(Request $request)
    {
        // $sip = inv_stock_to_production::select('inv_stock_to_production.sip_number','inv_stock_to_production.id as sip_id','inv_stock_to_production.mac_item_id','inv_mac_item.available_qty')
        //                     ->leftjoin('inv_purchase_req_item','inv_purchase_req_item.requisition_item_id','=','inv_stock_to_production.pr_item_id')
        //                     ->leftjoin('inv_mac_item','inv_mac_item.id','=','inv_stock_to_production.mac_item_id')
        //                     ->where('inv_purchase_req_item.Item_code','=',$request->row_material_id)
        //                     ->orderBy('inv_stock_to_production.id','desc')
        //                     ->get();
        // return $sip;
        $lots = inv_stock_management::select('inv_lot_allocation.id as lotid','inv_lot_allocation.lot_number','inv_stock_management.stock_qty')
                                        ->leftJoin('inv_lot_allocation','inv_lot_allocation.id','=','inv_stock_management.lot_id')
                                        ->where('inv_stock_management.item_id','=',$request->row_material_id)
                                        ->where('inv_stock_management.stock_qty','!=',0)
                                        ->orderBy('inv_lot_allocation.id','desc')
                                        ->get();
        return $lots;

    }
    public function fetchLotStock(Request $request)
    {
        $lot = inv_stock_management::select('inv_lot_allocation.id as lotid','inv_lot_allocation.lot_number','inv_stock_management.stock_qty')
                                        ->leftJoin('inv_lot_allocation','inv_lot_allocation.id','=','inv_stock_management.lot_id')
                                        ->where('inv_stock_management.lot_id','=',$request->lot_id)
                                        ->first();
        return $lot['stock_qty'];
    }
    public function transferOrder(Request $request)
    {
        
        $validation['moreItems.*.Itemcode'] = ['required'];
        //$validation['moreItems.*.sip_number'] = ['required'];
        $validation['moreItems.*.transfer_qty'] = ['required'];
       // $validation['moreItems.*.reason'] = ['required'];
        $validator = Validator::make($request->all(), $validation);
        if(!$validator->errors()->all())
        {
                $data['sto_number'] = "STO-" . $this->po_num_gen(DB::table('inv_stock_transfer_order')->where('inv_stock_transfer_order.sto_number', 'LIKE', 'STO%')->count(),1); 
                $data['status']= 1;
                $data['created_at']= date('Y-m-d H:i:s');
                $data['updated_at']= date('Y-m-d H:i:s');
                $data['created_user'] = config('user')['user_id'];
                $sto_id = $this->inv_stock_transfer_order->insert_data($data);
                //echo $sto_id;exit;
                foreach($request->moreItems as $key => $value) {
                    //echo $value['lot_number'];exit;
                    if(!empty($value['lot_number']))
                    $lot =  $value['lot_number'];
                    else
                    $lot = NULL;
                    $Request = [
                        //"item_code" => $value['Itemcode'],
                        "lot_id"=> $lot,
                        'item_id'=>$value['Itemcode'],
                        "transfer_qty"=>$value['transfer_qty'],
                        "transfer_reason"=>$value['reason'],
                        //"created_user" =>  config('user')['user_id']   
                    ];
                    $sto_item_id = $this->inv_stock_transfer_order_item->insert_data($Request);
                    $dat2 =[
                        'master'=>$sto_id,
                        'item'=>$sto_item_id,
                    ];
                    $rel =DB::table('inv_stock_transfer_order_item_rel')->insert($dat2);
                    $sto_item[]=$sto_item_id ;
                    if(!empty($value['lot_number']))
                    {
                        $stock = inv_stock_management::where('item_id','=',$value['Itemcode'])->where('lot_id','=',$value['lot_number'])->first();
                    }
                    else
                    {
                        $stock = inv_stock_management::where('item_id','=',$value['Itemcode'])->first();
                    }
                    $stock_qty = $stock->stock_qty - $value['transfer_qty'];
                    $stock->stock_qty = $stock_qty;
                    $stock->save();

                    $inf['item_id'] = $value['Itemcode'];
                    $inf['transaction_type'] = 6;
                    $inf['transaction_id'] = $sto_id;
                    $inf['transaction_qty'] = $value['transfer_qty'];
                    $inf['created_at'] = date('Y-m-d H:i:s');
                    $transaction = $this->inv_stock_transaction->insert_data($inf);
                    // $inv_mac_item = inv_mac_item::where('id',$sip['mac_item_id'])->first();
                    // $inv_mac_item->available_qty = $inv_mac_item->available_qty - $value['transfer_qty']; 
                    // $inv_mac_item->save();
                    
                }

            if(count($sto_item)==count($request->moreItems))
            $request->session()->flash('success', "You have successfully added Stock Transfer Order !");
            else
            $request->session()->flash('error', "You have failed to add  Stock Transfer Order !");
            return redirect("inventory/Stock/transfer");
        }
        if($validator->errors()->all())
        {
           // $request->session()->flash('error', "You have failed to add Stock Transfer Order !");
            return redirect("inventory/Stock/transfer-add")->withErrors($validator)->withInput();
        }
    }







    
    
    public function indirectupload()
    {
        $ExcelOBJ = new \stdClass();
        $ExcelOBJ->inputFileType = 'Xlsx';
        $ExcelOBJ->filename = 'SL-1-01.xlsx';
        //$ExcelOBJ->inputFileName = '/Applications/XAMPP/xamppfiles/htdocs/mel/sampleData/simple/15-09-2022/Top sheet creater_BAtch card to sheet 11SEPT (1).xlsx';
        $ExcelOBJ->inputFileName ='C:\xampp\htdocs\InventoryDataSheet_1.xlsx';
        $ExcelOBJ->aircraft = 'B737-MAX';
        $ExcelOBJ->spreadsheet = new Spreadsheet();
        $ExcelOBJ->reader = \PhpOffice\PhpSpreadsheet\IOFactory::createReader($ExcelOBJ->inputFileType);
        $ExcelOBJ->reader->setReadDataOnly(true);
        $ExcelOBJ->worksheetData = $ExcelOBJ->reader->listWorksheetInfo($ExcelOBJ->inputFileName);
        $this->indirectExcelsplitsheet($ExcelOBJ);
        exit;
    }
    public function indirectExcelsplitsheet($ExcelOBJ)
    {
        $ExcelOBJ->SQLdata = [];
        $ExcelOBJ->arrayinc = 0;

        foreach ($ExcelOBJ->worksheetData as $key => $worksheet) {
            $ExcelOBJ->sectionName = '';
            $ExcelOBJ->sheetName = $worksheet['worksheetName'];
            $ExcelOBJ->reader->setLoadSheetsOnly($ExcelOBJ->sheetName);
            $ExcelOBJ->spreadsheet = $ExcelOBJ->reader->load($ExcelOBJ->inputFileName);
            $ExcelOBJ->worksheet = $ExcelOBJ->spreadsheet->getActiveSheet();
            $ExcelOBJ->excelworksheet = $ExcelOBJ->worksheet->toArray();
            $ExcelOBJ->date_created = date('Y-m-d H:i:s');
            $ExcelOBJ->sheetname = $ExcelOBJ->sheetName;
            $this->insert_stock_indirect($ExcelOBJ);     
            //die("done");
        }
        exit('done');
    }

    function insert_stock_indirect($ExcelOBJ)
    {
        foreach ($ExcelOBJ->excelworksheet as $key => $excelsheet) {
    
            if ($key > 1 &&  $excelsheet[1]) 
             {
                $not_exist_item=[];
                $data['item_id'] = inventory_rawmaterial::where('item_code','=',$excelsheet[2])->pluck('id')->first();
                // if($data['item_id']==null)
                // {
                //     $not_exist_item[]=$excelsheet[1];
                // }
                //echo $data['item_id'];exit;
                $stck = DB::table('inv_stock_management')->where('item_id','=',$data['item_id'])->first();
                if($stck)
                {
                   // $ys[]= inv_stock_management::where('id','=',$stck->id)->increment('stock_qty',$excelsheet[4]);
                   $ys[]= inv_stock_management::where('id','=',$stck->id)->update(['stock_qty'=>$excelsheet[4]]);
                }
                else
                {
                    $data['stock_qty'] = $excelsheet[4];
                    DB::table('inv_stock_management')->insert($data);
                }
                
                $info['item_id'] = $data['item_id'];
                $info['transaction_type'] = 1;
                $info['transaction_qty'] = $excelsheet[4];
                $info['created_at'] = date('2022-12-01');
                DB::table('inv_stock_transaction')->insert($info);
            }
        }
        //print_r($not_exist_item);
    }


    public function removeExistOpenDirectStock()
    {
        $lots = DB::table('inv_lot_allocation')->where('inv_lot_allocation.si_invoice_item_id','=','NULL')->get();
        //print_r($lots);exit;
        foreach($lots as $lot)
        {
            DB::table('inv_stock_transaction')->where('lot_id','=',$lot->id)->delete();
            DB::table('inv_stock_management')->where('lot_id','=',$lot->id)->delete();
            //DB::table()->where('inv_lot_allocation')->where('id','=',$lot['id'])->delete();
        }
        DB::table('inv_lot_allocation')->where('inv_lot_allocation.si_invoice_item_id','=','NULL')->delete();
    }

    public function removeExistOpenIndirectStock()
    {
        $openstock = DB::table('inv_stock_transaction')->where('transaction_type','=',1)->whereNull('lot_id')->get();
        //print_r($openstock);exit;
        foreach($openstock as $stock)
        {
            DB::table('inv_stock_management')->where('item_id','=',$stock->item_id)->decrement('stock_qty',$stock->transaction_qty);
            //DB::table('inv_stock_transaction')->where('lot_id','=',$stock->id)->delete();
        }
        foreach($openstock as $stock)
        {
            //DB::table('inv_stock_management')->where('item_id','=',$stock->item_id)->decrement('stock_qty',$stock->transaction_qty);
            DB::table('inv_stock_transaction')->where('id','=',$stock->id)->delete();
        }
    }
    
    public function directupload()
    {
        $ExcelOBJ = new \stdClass();
        $ExcelOBJ->inputFileType = 'Xlsx';
        $ExcelOBJ->filename = 'SL-1-01.xlsx';
        //$ExcelOBJ->inputFileName = '/Applications/XAMPP/xamppfiles/htdocs/mel/sampleData/simple/15-09-2022/Top sheet creater_BAtch card to sheet 11SEPT (1).xlsx';
        $ExcelOBJ->inputFileName ='C:\xampp\htdocs\openStock11-07-23.xlsx';
        $ExcelOBJ->aircraft = 'B737-MAX';
        $ExcelOBJ->spreadsheet = new Spreadsheet();
        $ExcelOBJ->reader = \PhpOffice\PhpSpreadsheet\IOFactory::createReader($ExcelOBJ->inputFileType);
        $ExcelOBJ->reader->setReadDataOnly(true);
        $ExcelOBJ->worksheetData = $ExcelOBJ->reader->listWorksheetInfo($ExcelOBJ->inputFileName);
        $this->directExcelsplitsheet($ExcelOBJ);
        exit;
    }
    public function directExcelsplitsheet($ExcelOBJ)
    {
        $ExcelOBJ->SQLdata = [];
        $ExcelOBJ->arrayinc = 0;

        foreach ($ExcelOBJ->worksheetData as $key => $worksheet) {
            $ExcelOBJ->sectionName = '';
            $ExcelOBJ->sheetName = $worksheet['worksheetName'];
            $ExcelOBJ->reader->setLoadSheetsOnly($ExcelOBJ->sheetName);
            $ExcelOBJ->spreadsheet = $ExcelOBJ->reader->load($ExcelOBJ->inputFileName);
            $ExcelOBJ->worksheet = $ExcelOBJ->spreadsheet->getActiveSheet();
            $ExcelOBJ->excelworksheet = $ExcelOBJ->worksheet->toArray();
            $ExcelOBJ->date_created = date('Y-m-d H:i:s');
            $ExcelOBJ->sheetname = $ExcelOBJ->sheetName;
            $this->insert_stock_direct($ExcelOBJ);     
            //die("done");
        }
        exit('done');
    }

    function insert_stock_direct($ExcelOBJ)
    {
        foreach ($ExcelOBJ->excelworksheet as $key => $excelsheet) {
    
            if ($key > 1 &&  $excelsheet[1]) 
             {
                //echo $excelsheet[2];exit;
                $material_id = inventory_rawmaterial::where('item_code','=',$excelsheet[4])->pluck('id')->first();
                $lot = inv_lot_allocation::where('lot_number','=', $excelsheet[3])->get();
                if(count($lot)==0)
                {
                    $data['material_id'] = $material_id;
                    $data['lot_number']= $excelsheet[3];
                    $data['qty_received'] = $excelsheet[6];
                    $data['qty_accepted'] = $excelsheet[6];
                    $lot_id = DB::table('inv_lot_allocation')->insertGetId($data);
                    //echo $data['item_id'];exit;
                    $stock['lot_id'] = $lot_id;
                    $stock['item_id'] = $material_id;
                    $stock['stock_qty'] = $excelsheet[6];
                    DB::table('inv_stock_management')->insert($stock);
                    $info['item_id'] = $material_id;
                    $stock['lot_id'] = $lot_id;
                    $info['transaction_type'] = 1;
                    $info['transaction_qty'] = $excelsheet[6];
                    $info['created_at'] = date('2023-07-11');
                    DB::table('inv_stock_transaction')->insert($info);
                }
            }
        }
    }

    public function stockReport(Request $request)
    {
        $condition = [];
        if ($request->item_code) {
            $condition[] = ['inventory_rawmaterial.item_code','like', '%' . $request->item_code . '%'];
        }
        // if($request->supplier)
        // {
        //     $condition[] = [DB::raw("CONCAT(inv_supplier.vendor_id,' - ',inv_supplier.vendor_name)"), 'like', '%' . $request->supplier . '%'];
        // }
        if($request->item_type=='services')
        {
            $condition[] = ['inv_item_type.type_name','=', 'Services'];
        }
        if($request->item_type=='direct')
        {
            $condition[] = ['inv_item_type.type_name','=', 'Direct Items'];
        }
        if($request->item_type=='indirect')
        {
            $condition[] = ['inv_item_type.type_name','=', 'Indirect Items'];
        }
        /*$mac_items = inv_mac_item::select('inv_mac_item.*','inv_mac.mac_number','inv_mac.mac_date','inventory_rawmaterial.item_code','inventory_rawmaterial.hsn_code','inventory_rawmaterial.discription',
        'inv_item_type.type_name','inv_unit.unit_name','inv_lot_allocation.lot_number','inv_supplier_invoice_item.rate','inv_supplier_invoice_item.discount','inv_supplier_invoice_item.gst','inv_supplier.vendor_name',
        'inv_supplier.vendor_id','inventory_gst.igst','inventory_gst.cgst','inventory_gst.sgst')
                            ->leftJoin('inv_mac_item_rel','inv_mac_item_rel.item','=','inv_mac_item.id')
                            ->leftJoin('inv_mac','inv_mac.id','=','inv_mac_item_rel.master')
                            ->leftjoin('inv_purchase_req_item','inv_purchase_req_item.requisition_item_id','=','inv_mac_item.pr_item_id')
                            ->leftjoin('inventory_rawmaterial','inventory_rawmaterial.id','=','inv_purchase_req_item.item_code')
                            ->leftjoin('inv_item_type','inv_item_type.id','=','inventory_rawmaterial.item_type_id')
                            ->leftjoin('inv_unit', 'inv_unit.id','=', 'inventory_rawmaterial.issue_unit_id')
                            ->leftjoin('inv_supplier_invoice_item','inv_supplier_invoice_item.id','=','inv_mac_item.invoice_item_id')
                            ->leftjoin('inv_lot_allocation','inv_lot_allocation.si_invoice_item_id','=','inv_supplier_invoice_item.id')
                            ->leftjoin('inv_supplier_invoice_master','inv_supplier_invoice_master.id','=','inv_mac.invoice_id')
                            ->leftjoin('inv_supplier','inv_supplier.id','=','inv_supplier_invoice_master.supplier_id')
                            ->leftjoin('inventory_gst','inventory_gst.id','=','inv_supplier_invoice_item.gst')
                            ->where('inv_mac.status','=',1)
                            ->where('inv_mac_item.available_qty','!=',0)
                            ->where($condition)
                            ->orderBy('inv_mac_item.id','DESC')
                            ->distinct('inv_mac_item.id')
                            ->paginate(15);*/
        $stock_items = inv_stock_management::select('inv_stock_management.*','inventory_rawmaterial.item_code','inventory_rawmaterial.hsn_code','inventory_rawmaterial.discription',
        'inv_item_type.type_name','inv_unit.unit_name','inv_lot_allocation.lot_number')
                                ->leftjoin('inventory_rawmaterial','inventory_rawmaterial.id','=','inv_stock_management.item_id')
                                ->leftjoin('inv_item_type','inv_item_type.id','=','inventory_rawmaterial.item_type_id')
                                ->leftjoin('inv_unit', 'inv_unit.id','=', 'inventory_rawmaterial.issue_unit_id')
                                ->leftjoin('inv_lot_allocation', 'inv_lot_allocation.id','=', 'inv_stock_management.lot_id')
                                ->leftJoin('inv_mac_item','inv_mac_item.invoice_item_id','=','inv_lot_allocation.si_invoice_item_id')

                                ->where($condition)
                                ->where('inv_stock_management.stock_qty','!=',0)
                                ->orderBy('inv_stock_management.id','DESC')
                                ->distinct('inv_stock_management.id')
                                ->paginate(15);

        return view('pages/inventory/stock/stock-report',compact('stock_items'));
    }

    public function stockReportExport(Request $request)
    {
        //dd('test');
        $condition = [];
        if ($request->item_code) {
            $condition[] = ['inventory_rawmaterial.item_code','like', '%' . $request->item_code . '%'];
        }
        if($request->item_type=='services')
        {
            $condition[] = ['inv_item_type.type_name','=', 'Services'];
        }
        if($request->item_type=='direct')
        {
            $condition[] = ['inv_item_type.type_name','=', 'Direct Items'];
        }
        if($request->item_type=='indirect')
        {
            $condition[] = ['inv_item_type.type_name','=', 'Indirect Items'];
        }
        
        /*$mac_items = inv_mac_item::select('inv_mac_item.*','inv_mac.mac_number','inv_mac.mac_date','inventory_rawmaterial.item_code','inventory_rawmaterial.hsn_code','inventory_rawmaterial.discription',
            'inv_item_type.type_name','inv_unit.unit_name','inv_lot_allocation.lot_number','inv_supplier_invoice_item.rate','inv_supplier_invoice_item.discount','inv_supplier_invoice_item.gst','inv_supplier.vendor_name',
            'inv_supplier.vendor_id','inventory_gst.igst','inventory_gst.cgst','inventory_gst.sgst','user.f_name','user.l_name')
                                ->leftJoin('inv_mac_item_rel','inv_mac_item_rel.item','=','inv_mac_item.id')
                                ->leftJoin('inv_mac','inv_mac.id','=','inv_mac_item_rel.master')
                                ->leftjoin('inv_purchase_req_item','inv_purchase_req_item.requisition_item_id','=','inv_mac_item.pr_item_id')
                                ->leftjoin('inventory_rawmaterial','inventory_rawmaterial.id','=','inv_purchase_req_item.item_code')
                                ->leftjoin('inv_item_type','inv_item_type.id','=','inventory_rawmaterial.item_type_id')
                                ->leftjoin('inv_unit', 'inv_unit.id','=', 'inventory_rawmaterial.issue_unit_id')
                                ->leftjoin('inv_supplier_invoice_item','inv_supplier_invoice_item.id','=','inv_mac_item.invoice_item_id')
                                ->leftjoin('inv_lot_allocation','inv_lot_allocation.si_invoice_item_id','=','inv_supplier_invoice_item.id')
                                ->leftjoin('inv_supplier_invoice_master','inv_supplier_invoice_master.id','=','inv_mac.invoice_id')
                                ->leftjoin('inv_supplier','inv_supplier.id','=','inv_supplier_invoice_master.supplier_id')
                                ->leftjoin('inventory_gst','inventory_gst.id','=','inv_supplier_invoice_item.gst')
                                ->leftjoin('user','user.user_id','=','inv_mac.created_by')
                                ->where('inv_mac.status','=',1)
                                ->where('inv_mac_item.available_qty','!=',0)
                                ->where($condition)
                                ->orderBy('inv_mac_item.id','DESC')
                                ->distinct('inv_mac_item.id')
                                ->get();*/
            $stock_items = inv_stock_management::select('inv_stock_management.*','inventory_rawmaterial.item_code','inventory_rawmaterial.hsn_code','inventory_rawmaterial.discription',
                                'inv_item_type.type_name','inv_unit.unit_name','inv_lot_allocation.lot_number')
                                                        ->leftjoin('inventory_rawmaterial','inventory_rawmaterial.id','=','inv_stock_management.item_id')
                                                        ->leftjoin('inv_item_type','inv_item_type.id','=','inventory_rawmaterial.item_type_id')
                                                        ->leftjoin('inv_unit', 'inv_unit.id','=', 'inventory_rawmaterial.issue_unit_id')
                                                        ->leftjoin('inv_lot_allocation', 'inv_lot_allocation.id','=', 'inv_stock_management.lot_id')
                                                        ->where($condition)
                                                        ->where('inv_stock_management.stock_qty','!=',0)
                                                        ->orderBy('inv_stock_management.id','DESC')
                                                        ->distinct('inv_stock_management.id')
                                                        ->get();

            return Excel::download(new InventoryStockExport($stock_items), 'InventoryStockReport' . date('d-m-Y') . '.xlsx');
    }

    public function stockUpdate(Request $request)
    {
        $condition[] = ['inv_stock_management.id','=',$request->stock_id];
        $data['stock_qty'] = $request->quantity;
        $success = $this->inv_stock_management->update_data($condition,$data);
        if($success)
        $request->session()->flash('success', "You have successfully updated Stock !");
        else
        $request->session()->flash('error', "You have failed to update stock !");
        return redirect("inventory/stock-report");
    }

    public function transactionSlip(Request $request)
    {
        $condition=[];
        if($request->transaction_slip)
        {
            $condition[] = ['inv_transaction_slip.transaction_slip_number','like','%'.$request->transaction_slip.'%'];
        }
        if($request->item_code)
        {
            $condition[] = ['inventory_rawmaterial.item_code','like','%'.$request->item_code.'%'];
        }
        if($request->lot_number)
        {
            $condition[] = ['inv_lot_allocation.lot_number','like','%'.$request->lot_number.'%'];
        }
        $data['transaction_slip'] = inv_transaction_slip::select('inv_transaction_slip.*','inv_lot_allocation.lot_number','inv_stock_management.stock_qty',
        'inventory_rawmaterial.item_code','inventory_rawmaterial.discription','inventory_rawmaterial.hsn_code','inv_unit.unit_name','created.f_name as created_f_name',
        'created.l_name as created_l_name','accepted.f_name as accepted_f_name','accepted.l_name as accepted_l_name','work_centre.centre_code')
                                        ->leftJoin('inv_lot_allocation','inv_lot_allocation.id','=','inv_transaction_slip.lot_id')
                                        ->leftJoin('inv_stock_management','inv_stock_management.lot_id','=','inv_transaction_slip.lot_id')
                                        ->leftJoin('inventory_rawmaterial','inventory_rawmaterial.id','=','inv_stock_management.item_id')
                                        ->leftJoin('inv_unit', 'inv_unit.id','=', 'inventory_rawmaterial.issue_unit_id')
                                        ->leftJoin('user as created','created.user_id','=','inv_transaction_slip.created_by')
                                        ->leftJoin('user as accepted','accepted.user_id','=','inv_transaction_slip.accepted_by')
                                        ->leftJoin('work_centre','work_centre.id','=','inv_transaction_slip.work_centre')
                                        ->where($condition)
                                        ->distinct('inv_transaction_slip.id')
                                        ->orderBy('inv_transaction_slip.id','DESC')
                                        ->paginate(10);
        return view('pages.inventory.stock.transaction-slip',compact('data'));
    }
    public function transactionSlipAdd(Request $request)
    {
        if($request->isMethod('post'))
        {
            $validation['lot_id'] = ['required'];
            $validation['quantity'] = ['required'];
            //$validation['created_by'] = ['required'];
            $validation['transaction_slip'] = ['required'];
            $validator = Validator::make($request->all(), $validation);
            if(!$validator->errors()->all())
            {
                    if(date('m')==01 || date('m')==02 || date('m')==03)
                    {
                        $years_combo = date('y', strtotime('-1 year')).date('y');
                    }
                    else
                    {
                        $years_combo = date('y').date('y', strtotime('+1 year'));
                    }
                    $data['sip_number'] = "SIP1-".$this->year_combo_num_gen_inv(DB::table('inv_transaction_slip')->where('inv_transaction_slip.sip_number', 'LIKE', 'SIP1-'.$years_combo.'%')->count());
                    $data['transaction_slip_number'] = $request->transaction_slip; 
                    $data['lot_id'] = $request->lot_id; 
                    $data['quantity'] = $request->quantity; 
                    $data['created_by'] = $request->created_by; 
                    $data['accepted_by'] = $request->accepted_by;
                    $data['work_centre'] = $request->work_centre; 
                    $data['status']= 1;
                    $data['created_at']= date('Y-m-d H:i:s');
                    $data['updated_at']= date('Y-m-d H:i:s');
                    $add = $this->inv_transaction_slip->insert_data($data);
                    $ys= inv_stock_management::where('lot_id','=',$request->lot_id)->decrement('stock_qty',$request->quantity);
                    if($add && $ys)
                    $request->session()->flash('success', "You have successfully created a Transaction Slip !");
                    else
                    $request->session()->flash('error', "Transaction Slip creation is failed. Try again... !");
                    return redirect('inventory/transaction-slip');
            }
            if($validator->errors()->all())
            {
                return redirect('inventory/transaction-slip/add');
            }
                    
        }
        else
        {
            $data['work_centre'] = work_centre::where('status','=',1)->get();
            $condition1[] = ['user.status', '=', 1];
            $data['users'] = $this->User->get_all_users($condition1);
            return view('pages.inventory.stock.transaction-slip-add',compact('data'));
        }
        
    }

    function lotnumbersearch(Request $request)
    {
        if(!$request->q){
            return response()->json(['message'=>'Lot Number is not valid'], 500); 
        }
        $condition[] = ['inv_lot_allocation.lot_number','like','%'.strtoupper($request->q).'%'];
        $data = inv_lot_allocation::select('inv_lot_allocation.id','inv_lot_allocation.lot_number as text','inventory_rawmaterial.item_code',
        'inventory_rawmaterial.discription','inventory_rawmaterial.hsn_code','inv_unit.unit_name','inv_stock_management.stock_qty')
                                            ->leftJoin('inv_stock_management','inv_stock_management.lot_id','=','inv_lot_allocation.id')
                                            ->leftJoin('inventory_rawmaterial','inventory_rawmaterial.id','=','inv_stock_management.item_id')
                                            ->leftJoin('inv_unit', 'inv_unit.id','=', 'inventory_rawmaterial.issue_unit_id')
                                            ->where('inv_stock_management.stock_qty','!=',0)
                                            ->where($condition)
                                            ->distinct('inv_lot_allocation.id')
                                            ->get();
        if(!empty( $data)){
            return response()->json( $data, 200); 
        }else{
            return response()->json(['message'=>'Lot Number is not valid'], 500); 
        }
    }

    public function resetBatchInputMaterial()
    {
        return view('pages.inventory.stock.reset-batchcard-input-material');    
    }
    public function getbatchcard(Request $request)
    {
        if(!$request->q){
            return response()->json(['message'=>'Batchcard is not valid'], 500); 
        }
        $condition[] = ['batchcard_batchcard.batch_no','like','%'.strtoupper($request->q).'%'];
        $data = $this->batchcard->get_batchcards($condition);
       // $data  = $this->inventory_rawmaterial->getItems($condition);
        if(!empty( $data)){
            return response()->json( $data, 200); 
        }else{
            return response()->json(['message'=>'Batchcard is not valid'], 500); 
        }
    }
    public function productInputMaterial(Request $request)
    {
        if($request->isMethod('post'))
        {
            $batch_material = batchcard_material::where('batchcard_id','=',$request->batch_id)->where('id','=',$request->batch_input_material_id)->first();
            if(!empty($batch_material))
            {
                $data = [
                    'batchcard_id'=>$request->batch_id,
                    //'product_inputmaterial_id'=>$request->product_inputmaterial_id,
                    'item_id'=>$request->material,
                    'quantity'=>0,
                ];
                $update = $this->batchcard_material->update_data(['id'=>$batch_material['id']],$data);
                if($update)
                $request->session()->flash('success',  "You have successfully updated a batchcard input material !");
                else
                $request->session()->flash('error',  "You have failed updation of batchcard input material !");
            }
            else
            {
                $data = [
                    'batchcard_id'=>$request->batch_id,
                    'product_inputmaterial_id'=>$request->product_inputmaterial_id,
                    'item_id'=>$request->material,
                    'quantity'=>0,
                ];
                $add = $this->batchcard_material->insert_data($data);
                if($add)
                $request->session()->flash('success',  "You have successfully inserted a batchcard input material !");
                else
                $request->session()->flash('error',  "You have failed insertion of batchcard input material !");
            }
            return redirect()->back();
        }
        else
        {
            $input_materials = product_input_material::select('product_input_material.id','material_option1.item_code as item1','material_option1.id as item1_id','material_option2.item_code as item2','material_option2.id as item2_id',
            'material_option3.item_code as item3','material_option3.id as item3_id')
                                    ->leftJoin('inventory_rawmaterial as material_option1','material_option1.id','=','product_input_material.item_id1')
                                    ->leftJoin('inventory_rawmaterial as material_option2','material_option2.id','=','product_input_material.item_id2')
                                    ->leftJoin('inventory_rawmaterial as material_option3','material_option3.id','=','product_input_material.item_id3')
                                    ->where('product_input_material.product_id','=',$request->product_id)
                                    ->get();
            //return $input_materials;
            $i=1;
            $data = '<tr>
                        <th>Sl No.</th>
                        <th>Option1</th>
                        <th>Option2</th>
                        <th>Option3
                    </tr>';
            foreach($input_materials as $material)
            {
                $data .= '<tr>
                            <th>'.$i++.'
                            <input type="hidden" name="product_inputmaterial_id" value="'.$material['id'].'"></th></th>';
                if($material['item1_id']==0)
                {
                    $batch_input_material = batchcard_material::where('batchcard_id','=',$request->batch_id)
                                                        ->where('item_id','=',$material['item1_id'])
                                                        ->get();
                    if(count($batch_input_material)>0)
                    {
                    $data.='<input type="hidden"  name="batch_input_material_id" value="'.$batch_input_material[0]['id'].'" ><th><input type="radio" class="item-select-radio" checked name="material" value="0">&nbsp; Assembly</th>';
                    }
                    else
                    $data.='<th><input type="radio" class="item-select-radio"  name="material" value="0">&nbsp; Assembly</th>';
                }
                else
                {
                    $batch_input_material = batchcard_material::where('batchcard_id','=',$request->batch_id)
                                                        ->where('item_id','=',$material['item1_id'])
                                                        ->get();
                    if(count($batch_input_material)>0)                                   
                    $data.='<th><input type="hidden"  name="batch_input_material_id" value="'.$batch_input_material[0]['id'].'" ><input type="radio" class="item-select-radio" checked name="material" value="'.$material['item1_id'].'">&nbsp; '.$material['item1'].'</th>';
                    else
                    $data.='<th><input type="radio" class="item-select-radio"  name="material" value="'.$material['item1_id'].'">&nbsp; '.$material['item1'].'</th>';
                }
                if($material['item2_id']!=NULL ) 
                {
                    if($material['item2_id']==0)
                    {
                        $batch_input_material = batchcard_material::where('batchcard_id','=',$request->batch_id)
                                                        ->where('item_id','=',$material['item2_id'])
                                                        ->get();
                        //$data.='<th><input type="radio" class="item-select-radio" name="material" value="0">&nbsp; Assembly</th>';
                        if(count($batch_input_material)>0)
                        $data.='<th><input type="hidden"  name="batch_input_material_id" value="'.$batch_input_material[0]['id'].'" ><input type="radio" class="item-select-radio" checked name="material" value="0">&nbsp; Assembly</th>';
                        else
                        $data.='<th><input type="radio" class="item-select-radio"  name="material" value="0">&nbsp; Assembly</th>';
                    }
                    else
                    {
                        $batch_input_material = batchcard_material::where('batchcard_id','=',$request->batch_id)
                                                        ->where('item_id','=',$material['item2_id'])
                                                        ->get();
                        if(count($batch_input_material)>0)
                        $data.='<th><input type="hidden"  name="batch_input_material_id" value="'.$batch_input_material[0]['id'].'" ><input type="radio" class="item-select-radio" checked name="material" value="'.$material['item2_id'].'">&nbsp; '.$material['item2'].'</th>';
                        else
                        $data.='<th><input type="radio" class="item-select-radio"  name="material" value="'.$material['item2_id'].'">&nbsp; '.$material['item2'].'</th>';
                    }
                }
                else
                {
                    $data.='<th></th>';
                }
                if($material['item3_id']!=NULL ) 
                {
                    if($material['item3_id']==0)
                    {
                        $batch_input_material = batchcard_material::where('batchcard_id','=',$request->batch_id)
                                                        ->where('item_id','=',$material['item3_id'])
                                                        ->get();
                        if(count($batch_input_material)>0)
                        $data.='<th><input type="hidden"  name="batch_input_material_id" value="'.$batch_input_material[0]['id'].'" ><input type="radio" checked class="item-select-radio" name="material" value="0">&nbsp; Assembly</th>';
                        else
                        $data.='<th><input type="radio" class="item-select-radio" name="material" value="0">&nbsp; Assembly</th>';
                    }
                    else
                    {
                        $batch_input_material = batchcard_material::where('batchcard_id','=',$request->batch_id)
                                                        ->where('item_id','=',$material['item3_id'])
                                                        ->get();
                        if(count($batch_input_material)>0)
                        $data.='<th><input type="hidden"  name="batch_input_material_id" value="'.$batch_input_material[0]['id'].'" ><input type="radio" class="item-select-radio" checked name="material" value="'.$material['item3_id'].'">&nbsp; '.$material['item3'].'</th>';
                        else
                        $data.='<th><input type="radio" class="item-select-radio" name="material" value="'.$material['item3_id'].'">&nbsp; '.$material['item3'].'</th>';
                    }
                }
                else
                {
                    $data.='<th></th>';
                }

            }
            return $data;
        }
        
    }
    public function underProcessSIP()
    {
        $work_centre = work_centre::where('status','=',1)->get();
        $batchcards = batchcard_material::select('batchcard_materials.id as batchcard_material_id','batchcard_batchcard.id as batchcard_id','batchcard_batchcard.batch_no','batchcard_materials.item_id','batchcard_materials.quantity as material_qty',
        'batchcard_batchcard.quantity as sku_quantity','product_product.sku_code','inv_unit.unit_name','inventory_rawmaterial.item_code','inventory_rawmaterial.id as rawmaterial_id')
                ->leftJoin('batchcard_batchcard','batchcard_batchcard.id','=', 'batchcard_materials.batchcard_id')
                ->leftJoin('product_product','batchcard_batchcard.product_id','=', 'product_product.id')
                ->leftJoin('inventory_rawmaterial','inventory_rawmaterial.id','=','batchcard_materials.item_id')
                ->leftJoin('inv_unit', 'inv_unit.id','=', 'inventory_rawmaterial.issue_unit_id')
                //->whereNotIn('batchcard_materials.id',$arr)
                ->where('batchcard_batchcard.is_alloted','=',0)
                ->where('batchcard_batchcard.is_trade','=',0)
                //->where('batchcard_materials.item_id','=',$request->item_id)
                //->orderBy('batchcard_batchcard.batch_no','ASC')
                ->orderBy('batchcard_batchcard.id','DESC')
                ->get();
        return view('pages.inventory.stock.under-process-sip',compact('work_centre','batchcards'));
    }
    public function addUnderProcessSIP(Request $request)
    {
        $validation['lot_id'] = ['required'];
        $validation['batchcard'] = ['required'];
        $validation['work_centre'] = ['required'];
        $validation['qty_to_production'] = ['required'];
        $validator = Validator::make($request->all(), $validation);
        if(!$validator->errors()->all())
        {
            if(date('m')==01 || date('m')==02 || date('m')==03)
            {
                $years_combo = date('y', strtotime('-1 year')).date('y');
            }
            else
            {
                $years_combo = date('y').date('y', strtotime('+1 year'));
            }
           // $lot_data= $this->inv_lot_allocation->get_single_lot1(['inv_lot_allocation.id'=>$request->lot_id]);
            $data['sip_number'] = "SIP2-".$this->year_combo_num_gen_inv(DB::table('inv_stock_to_production')->where('inv_stock_to_production.sip_number', 'LIKE', 'SIP2-'.$years_combo.'%')->count()); 
            $data['lot_id'] = $request->lot_id;
            $data['qty_to_production'] = $request->qty_to_production;
            $data['type'] = 2;
            $data['status'] = 1;
            $data['work_centre'] = $request->work_centre;
            $data['transaction_slip'] = $request->transaction_slip;
            $data['under_development'] = 1;
            $data['created_at']= date('Y-m-d H:i:s');
            $data['updated_at']= date('Y-m-d H:i:s');
            $mac_item = inv_mac_item::leftjoin('inv_supplier_invoice_item','inv_supplier_invoice_item.id','=','inv_mac_item.invoice_item_id')
                                ->leftJoin('inv_lot_allocation','inv_lot_allocation.si_invoice_item_id','=','inv_supplier_invoice_item.id')
                                ->leftjoin('inv_miq_item','inv_miq_item.invoice_item_id','=','inv_supplier_invoice_item.id')
                                ->where('inv_lot_allocation.id','=',$request->lot_id)
                                ->select('inv_mac_item.id','inv_mac_item.pr_item_id','inv_mac_item.accepted_quantity')->first();                   

            // $inv_mac_item->available_qty = 0;
            // $inv_mac_item->save();

            $stock = inv_stock_management::where('lot_id','=',$request->lot_id)->first();
            // $stockQty = $stock->stock_qty - array_sum($request->qty_to_production);
            $stockQty = $stock->stock_qty - $request->qty_to_production;
            $stock->stock_qty = $stockQty;
            $stock->save();
            if($mac_item)
            {
                $inv_mac_item = inv_mac_item::where('id',$mac_item['id'])->first();
                $ys1[]= inv_mac_item::where('id','=',$mac_item['id'])->decrement('available_qty',$request->qty_to_production);
                $data['pr_item_id'] = $inv_mac_item['pr_item_id'];
                $data['mac_item_id'] = $mac_item['id'];
            }  

            $data['stock_id']=$stock['id'];
            $sip_master = $this->inv_stock_to_production->insert_data($data);
           
            if($sip_master)
            { 
                foreach($request->batchcard as $batchcard)
                {
                    $batchdata = batchcard::where('batchcard_batchcard.id','=',$batchcard)
                                                   // ->where('item_id','=',$request->item_code)
                                                    ->first();
                    $batch['batchcard_id']=$batchcard;
                    //$batch['batchcard_material_id']=$batchdata['id'];
                    $batch['material_id']=$request->item_code;
                    //$batch['mac_item_id']=$mac_item['id'];
                    //$batch['qty_to_production'] = $qty_to_production_array[$i];
                    $sip_item = $this->inv_stock_to_production_item->insert_data($batch);

                    $rel['master'] = $sip_master;
                    $rel['item'] = $sip_item;
                    DB::table('inv_stock_to_production_item_rel')->insert($rel);
                }
               
               
                $request->session()->flash('success', "You have successfully added Stock issue to production !");
            }
            else
            {
                $request->session()->flash('error', "You have failed to add Stock issue to production !");
            }
            return redirect("inventory/Stock/ToProduction");

        }
        
    }
    public function Add_stock_location(Request $request)
    {
        if ($request->location) {

            $add = product_stock_location::insertGetId(['location_name' => $request->location]);
            if ($add) {
                $request->session()->flash('success',  "You have successfully inserted a stock location!");
                return redirect()->back();
            } else {
                $request->session()->flash('error',  "You have failed insertion of stock location !");
                return redirect()->back();
            }
        } else {
            $stock_location = product_stock_location::get();
            return view('pages.inventory.stock.stock-location-add', compact('stock_location'));
        }
    }

    public function AllSIPItemExport(Request $request)
    {
        
        if($request)
        {
            return Excel::download(new AllSIPItemsExport($request), 'SIP_list' . date('d-m-Y') . '.xlsx');
        }
        else
        {
            $request =null;
            return Excel::download(new AllSIPItemsExport($request), 'SIP_list' . date('d-m-Y') . '.xlsx');
        }
    }

    public function AllSTOItemExport(Request $request)
    {
        
        if($request)
        {
            return Excel::download(new AllSTOItemsExport($request), 'STO_list' . date('d-m-Y') . '.xlsx');
        }
        else
        {
            $request =null;
            return Excel::download(new AllSTOItemsExport($request), 'STO_list' . date('d-m-Y') . '.xlsx');
        }
    }

    public function AllSRPItemExport(Request $request)
    {
        
        if($request)
        {
            return Excel::download(new AllSRPItemsExport($request), 'SIR_list' . date('d-m-Y') . '.xlsx');
        }
        else
        {
            $request =null;
            return Excel::download(new AllSRPItemsExport($request), 'SIR_list' . date('d-m-Y') . '.xlsx');
        }
    }
    

}
