<?php

namespace App\Http\Controllers\Web;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\PurchaseDetails\inventory_rawmaterial;
use App\Models\PurchaseDetails\inv_supplier_itemrate;
use PhpOffice\PhpSpreadsheet\Reader\Xlsx as ReaderXlsx;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use App\Models\currency_exchange_rate;
use DB;
use Validator;
class RowMaterialController extends Controller
{
    public function __construct()
    {
        $this->User = new User;
        $this->inventory_rawmaterial = new inventory_rawmaterial;
        $this->inv_supplier_itemrate = new inv_supplier_itemrate;
        $this->currency_exchange_rate = new currency_exchange_rate;

    }
    public function materialList(Request $request)
    {
        $condition = [];
        if($request->item_code){
            $condition[]=['inventory_rawmaterial.item_code','LIKE','%'.$request->item_code.'%'];
        }
        if($request->type1){
            $condition[]=['inv_item_type.type_name','LIKE','%'.$request->type1.'%'];
        }
        if($request->type2){
            $condition[]=['inv_item_type_2.type_name','LIKE','%'.$request->type2.'%'];
        }
        if($request->origin){
            $condition[]=['inventory_rawmaterial.item_origin','LIKE','%'.$request->origin.'%'];
        }
        $data['materials']=$this->inventory_rawmaterial->getData($condition);
        return view('pages/row-material/material-list',compact('data'));
    }

    public function materialAdd(Request $request)
    {
        if ($request->isMethod('post')) 
        {
            $validation['item_code'] = ['required'];
            $validation['item_type1'] = ['required'];
            $validation['item_type2'] = ['required'];
            $validation['item_description'] = ['required'];
            $validation['issue_unit'] = ['required'];
            $validation['receipt_unit'] = ['required'];
            $validation['stock_keeping_unit'] = ['required'];
            $validator = Validator::make($request->all(), $validation);
            if (!$validator->errors()->all()) 
            {
                $data['item_code']= $request->item_code;
                $data['item_name']= $request->item_name;
                $data['item_short_name']= $request->item_short_name;
                $data['item_type_id']= $request->item_type1;
                $data['item_type_id_2']= $request->item_type2;
                $data['hsn_code']= $request->hsn_code;
                $data['issue_unit_id']= $request->issue_unit;
                $data['receipt_unit_id']= $request->receipt_unit;
                $data['stock_keeping_unit_id']= $request->stock_keeping_unit;
                $data['stock_type']= $request->stock_type;
                $data['conv_fact_in_ru']= $request->conv_fact_ru;
                $data['conv_fact_in_iu']= $request->conv_fact_iu;
                $data['reorder_level']= $request->reorder_level;
                $data['min_stock']= $request->min_stock_qty;
                $data['max_stock']= $request->max_stock_qty;
                $data['over_stock']= $request->over_stock_level;
                $data['discription']= $request->item_description;
                $data['short_description']= $request->item_short_description;
                $data['item_origin']= $request->item_origin;
                $data['brand_id']= $request->brand;
                $data['company_purchase_rate']= $request->adler_purchase_rate;
                $data['purchase_rate']= $request->purchase_rate;
                $data['sales_rate']= $request->sales_rate;
                $data['ad_sp1']= $request->adsp1;
                $data['ad_sp2']= $request->adsp2;
                $data['path']= $request->path;
                $data['hierarchy_path']= $request->hierarchy_path;
                $data['unit_weight_kgs']= $request->unit_weight;
                $data['revision_record']= $request->revision_record;
                $data['expiry_control']= $request->expiry_control_required;
                $data['method_of_expiry']= $request->method_expiry_control;
                //$data['item_code']= $request->modification_record;
                $data['checker_id']= $request->checker;
                $data['approver_id']= $request->approved;
                $data['is_active']= 1;
                $data['created'] = date('Y-m-d H:i:s');
                $data['updated'] = date('Y-m-d H:i:s');
                $success = $this->inventory_rawmaterial->insertdata($data);
                if($success)
                {
                $request->session()->flash('success', "You have successfully added a row material !");
                return redirect("row-material/list");
                }
                else
                {
                    $request->session()->flash('error', "You have failed to add a row material !");
                    return redirect("row-material/add");
                }
            }
            if ($validator->errors()->all()) {
                return redirect("row-material/add")->withErrors($validator)->withInput();

            }
           
        }   
        $data['type1'] = DB::table('inv_item_type')->select('id','type_name')->where('is_active','=',1)->get();
        $data['type2'] = DB::table('inv_item_type_2')->select('id','type_name')->where('is_active','=',1)->get();
        $data['units'] = DB::table('inventory_rawmaterial_issue_unit')->select('id','unit_name')->where('is_active','=',1)->get();
        $data['users'] = $this->User->get_all_users([['user.status','=',1]]);
        return view('pages/row-material/material-add',compact('data'));
    }

    public function materialDeactivate(Request $request)
    {
        if($request->id)
        {
            $this->inventory_rawmaterial->updatedata(['id'=>$request->id],['is_active'=>0]);
            $request->session()->flash('success',  "You have successfully deactivated a row material !");
        }
       return redirect('row-material/list');
    }
    public function materialActivate(Request $request)
    {
        if($request->id)
        {
            $this->inventory_rawmaterial->updatedata(['id'=>$request->id],['is_active'=>1]);
            $request->session()->flash('success',  "You have successfully activated a row material !");
        }
       return redirect('row-material/list');
    }

    public function materialEdit(Request $request)
    {
        if ($request->isMethod('post')) 
        {
            $validation['item_code'] = ['required'];
            $validation['item_type1'] = ['required'];
            $validation['item_type2'] = ['required'];
            $validation['item_description'] = ['required'];
            $validation['issue_unit'] = ['required'];
            $validation['receipt_unit'] = ['required'];
            $validation['stock_keeping_unit'] = ['required'];
            $validator = Validator::make($request->all(), $validation);
            if (!$validator->errors()->all()) 
            {
                $data['item_code']= $request->item_code;
                $data['item_name']= $request->item_name;
                $data['item_short_name']= $request->item_short_name;
                $data['item_type_id']= $request->item_type1;
                $data['item_type_id_2']= $request->item_type2;
                $data['hsn_code']= $request->hsn_code;
                $data['issue_unit_id']= $request->issue_unit;
                $data['receipt_unit_id']= $request->receipt_unit;
                $data['stock_keeping_unit_id']= $request->stock_keeping_unit;
                $data['stock_type']= $request->stock_type;
                $data['conv_fact_in_ru']= $request->conv_fact_ru;
                $data['conv_fact_in_iu']= $request->conv_fact_iu;
                $data['reorder_level']= $request->reorder_level;
                $data['min_stock']= $request->min_stock_qty;
                $data['max_stock']= $request->max_stock_qty;
                $data['over_stock']= $request->over_stock_level;
                $data['discription']= $request->item_description;
                $data['short_description']= $request->item_short_description;
                $data['item_origin']= $request->item_origin;
                $data['brand_id']= $request->brand;
                $data['company_purchase_rate']= $request->adler_purchase_rate;
                $data['purchase_rate']= $request->purchase_rate;
                $data['sales_rate']= $request->sales_rate;
                $data['ad_sp1']= $request->adsp1;
                $data['ad_sp2']= $request->adsp2;
                $data['path']= $request->path;
                $data['hierarchy_path']= $request->hierarchy_path;
                $data['unit_weight_kgs']= $request->unit_weight;
                $data['revision_record']= $request->revision_record;
                $data['expiry_control']= $request->expiry_control_required;
                $data['method_of_expiry']= $request->method_expiry_control;
                //$data['item_code']= $request->modification_record;
                $data['checker_id']= $request->checker;
                $data['approver_id']= $request->approved;
                $data['is_active']= 1;
                $data['updated'] = date('Y-m-d H:i:s');
                $success = $this->inventory_rawmaterial->updatedata(['id'=>$request->id],$data);
                if($success)
                {
                    $request->session()->flash('success', "You have successfully updated a row material !");
                    return redirect("row-material/list");
                }
                else
                {
                    $request->session()->flash('error', "You have failed to update a row material !");
                    return redirect("row-material/edit/".$request->id);
                }
            }
            if ($validator->errors()->all()) {
                return redirect("row-material/edit/".$request->id)->withErrors($validator)->withInput();

            }
        }
            $edit = $this->inventory_rawmaterial->get_single_data(['id'=>$request->id]);
            $data['type1'] = DB::table('inv_item_type')->select('id','type_name')->where('is_active','=',1)->get();
            $data['type2'] = DB::table('inv_item_type_2')->select('id','type_name')->where('is_active','=',1)->get();
            $data['units'] = DB::table('inventory_rawmaterial_issue_unit')->select('id','unit_name')->where('is_active','=',1)->get();
            $data['users'] = $this->User->get_all_users([['user.status','=',1]]);
            return view('pages/row-material/material-add',compact('data','edit'));
    }

    public function materialUpload(Request $request)
    {
        return view('pages/row-material/material-list-upload');
    }
    public function materialPostUpload(Request $request)
    {
        $file = $request->file('file');
        if ($file) 
        {
            $ExcelOBJ = new \stdClass();
            $path = storage_path().'/app/'.$request->file('file')->store('temp');
            $ExcelOBJ->inputFileName = $path;
            $ExcelOBJ->inputFileType = 'Xlsx';
            $ExcelOBJ->spreadsheet = new Spreadsheet();
            $ExcelOBJ->reader = \PhpOffice\PhpSpreadsheet\IOFactory::createReader($ExcelOBJ->inputFileType);
            $ExcelOBJ->reader->setReadDataOnly(true);
            $ExcelOBJ->worksheetData = $ExcelOBJ->reader->listWorksheetInfo($ExcelOBJ->inputFileName);
            $no_column = 36;
            $sheet1_column_count = $ExcelOBJ->worksheetData[0]['totalColumns'];
            //echo $sheet1_column_count;exit;
            if($sheet1_column_count == $no_column)
            {
                $res = $this->rawmaterialsplitsheet($ExcelOBJ);
                //print_r($res);exit;
                if($res==1)
                {
                   $request->session()->flash('success',  "Successfully uploaded.");
                   return redirect('row-material/upload');
                }
                else{
                   $request->session()->flash('error',  "The data already uploaded.");
                   return redirect('row-material/upload');
                }
           }
           else 
           {
               $request->session()->flash('error',  "Column not matching.. Please download the excel template and check the column count");
               return redirect('row-material/upload');
           }
        }

    }
    function rawmaterialsplitsheet($ExcelOBJ)
    {
        $ExcelOBJ->SQLdata = [];
        $ExcelOBJ->arrayinc = 0;
        foreach ($ExcelOBJ->worksheetData as $key => $worksheet) 
        {
            $ExcelOBJ->sectionName = '';
            $ExcelOBJ->sheetName = $worksheet['worksheetName'];
            $ExcelOBJ->reader->setLoadSheetsOnly($ExcelOBJ->sheetName);
            $ExcelOBJ->spreadsheet = $ExcelOBJ->reader->load($ExcelOBJ->inputFileName);
            $ExcelOBJ->worksheet = $ExcelOBJ->spreadsheet->getActiveSheet();
            $ExcelOBJ->excelworksheet = $ExcelOBJ->worksheet->toArray();
           // print_r(json_encode($ExcelOBJ->excelworksheet));exit;
            $ExcelOBJ->date_created = date('Y-m-d H:i:s');
            $ExcelOBJ->sheetname = $ExcelOBJ->sheetName;
            $res = $this->insert_rawmaterial($ExcelOBJ);
            return $res;
        }
    }
    public function insert_rawmaterial($ExcelOBJ)
    {
        foreach ($ExcelOBJ->excelworksheet as $key => $excelsheet) 
        {
            if($key > 1 &&  $excelsheet[1])
            { 
                if(!DB::table('inventory_rawmaterial')->where('item_code',$excelsheet[1])->first())
                {   
                    $data['item_code'] = $excelsheet[1];
                    $data['item_name'] = $excelsheet[2];
                    $data['item_short_name'] = $excelsheet[3];
                    $data['discription'] = $excelsheet[4];
                    $data['short_description'] =  $excelsheet[5];
                    $data['item_type_id'] = $this->identify_id($excelsheet[6],"ITEM TYPE");
                    //$data['item_type_id'] = 4;
                    $data['item_type_id_2'] = $this->identify_id($excelsheet[7],"ITEM TYPE 2");
                    //$data['item_type_id_2'] = 18;
                    $data['receipt_unit_id'] = $this->identify_id($excelsheet[8],"RECEIPT UNIT");
                    $data['issue_unit_id'] = $this->identify_id($excelsheet[8],"ISSUE UNIT");
                    $data['stock_keeping_unit_id'] =  $this->identify_id($excelsheet[8],"STOCK KEEPING UNIT");
                    $data['conv_fact_in_ru'] =  $excelsheet[11];
                    $data['conv_fact_in_iu'] =  $excelsheet[12];
                    $data['reorder_level'] = $excelsheet[13];
                    $data['min_stock'] = $excelsheet[14];
                    $data['max_stock'] = $excelsheet[15];
                    $data['over_stock'] = $excelsheet[16];
                    $data['item_origin'] = $excelsheet[17];
                    $data['min_stock_set_date'] =   (\PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject(intval($excelsheet[18]))->format('Y-m-d') == '1970-01-01') ? '2000-01-01' : \PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject(intval($excelsheet[18]))->format('Y-m-d');
                    $data['max_stock_set_date'] =   (\PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject(intval($excelsheet[19]))->format('Y-m-d') == '1970-01-01') ? '2000-01-01' : \PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject(intval($excelsheet[19]))->format('Y-m-d');
                    $data['reorder_set_date']   =   (\PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject(intval($excelsheet[20]))->format('Y-m-d') == '1970-01-01') ? '2000-01-01' : \PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject(intval($excelsheet[20]))->format('Y-m-d');
                    $data['overstock_set_date'] =   (\PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject(intval($excelsheet[21]))->format('Y-m-d') == '1970-01-01') ? '2000-01-01' : \PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject(intval($excelsheet[21]))->format('Y-m-d');
                    $data['quantity'] = $excelsheet[22];
                    $data['stock_type'] = $excelsheet[23];
                    $data['brand_id'] = $excelsheet[24];
                    $data['company_purchase_rate'] = $excelsheet[25];
                    $data['purchase_rate'] = $excelsheet[26];
                    $data['sales_rate'] = $excelsheet[27];
                    $data['ad_sp1'] = $excelsheet[28];
                    $data['ad_sp2'] = $excelsheet[29];
                    $data['path'] = $excelsheet[30];
                    $data['hierarchy_path'] = $excelsheet[31];
                    $data['unit_weight_kgs'] = $excelsheet[32];
                    $data['revision_record'] = $excelsheet[33];
                    $data['is_active'] = 1;
                    $data['expiry_control'] = ($excelsheet[35] == 'N') ? 0 : 1;
                    $data['is_expiry'] = ($excelsheet[35] == 'N') ? 0 : 1;
                    $data['created'] = date('Y-m-d');
                    $res[] = DB::table('inventory_rawmaterial')->insert($data);
                }
                else
                {
                    $data['item_code'] = $excelsheet[1];
                    $data['item_name'] = $excelsheet[2];
                    $data['item_short_name'] = $excelsheet[3];
                    $data['discription'] = $excelsheet[4];
                    $data['short_description'] =  $excelsheet[5];
                    $data['item_type_id'] = $this->identify_id($excelsheet[6],"ITEM TYPE");
                    //$data['item_type_id'] = 4;
                    $data['item_type_id_2'] = $this->identify_id($excelsheet[7],"ITEM TYPE 2");
                    //$data['item_type_id_2'] = 18;
                    $data['receipt_unit_id'] = $this->identify_id($excelsheet[8],"RECEIPT UNIT");
                    $data['issue_unit_id'] = $this->identify_id($excelsheet[8],"ISSUE UNIT");
                    $data['stock_keeping_unit_id'] =  $this->identify_id($excelsheet[8],"STOCK KEEPING UNIT");
                    $data['conv_fact_in_ru'] =  $excelsheet[11];
                    $data['conv_fact_in_iu'] =  $excelsheet[12];
                    $data['reorder_level'] = $excelsheet[13];
                    $data['min_stock'] = $excelsheet[14];
                    $data['max_stock'] = $excelsheet[15];
                    $data['over_stock'] = $excelsheet[16];
                    $data['item_origin'] = $excelsheet[17];
                    $data['min_stock_set_date'] =   (\PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject(intval($excelsheet[18]))->format('Y-m-d') == '1970-01-01') ? '2000-01-01' : \PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject(intval($excelsheet[18]))->format('Y-m-d');
                    $data['max_stock_set_date'] =   (\PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject(intval($excelsheet[19]))->format('Y-m-d') == '1970-01-01') ? '2000-01-01' : \PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject(intval($excelsheet[19]))->format('Y-m-d');
                    $data['reorder_set_date']   =   (\PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject(intval($excelsheet[20]))->format('Y-m-d') == '1970-01-01') ? '2000-01-01' : \PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject(intval($excelsheet[20]))->format('Y-m-d');
                    $data['overstock_set_date'] =   (\PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject(intval($excelsheet[21]))->format('Y-m-d') == '1970-01-01') ? '2000-01-01' : \PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject(intval($excelsheet[21]))->format('Y-m-d');
                    $data['quantity'] = $excelsheet[22];
                    $data['stock_type'] = $excelsheet[23];
                    $data['brand_id'] = $excelsheet[24];
                    $data['company_purchase_rate'] = $excelsheet[25];
                    $data['purchase_rate'] = $excelsheet[26];
                    $data['sales_rate'] = $excelsheet[27];
                    $data['ad_sp1'] = $excelsheet[28];
                    $data['ad_sp2'] = $excelsheet[29];
                    $data['path'] = $excelsheet[30];
                    $data['hierarchy_path'] = $excelsheet[31];
                    $data['unit_weight_kgs'] = $excelsheet[32];
                    $data['revision_record'] = $excelsheet[33];
                    $data['is_active'] = 1;
                    $data['expiry_control'] = ($excelsheet[35] == 'N') ? 0 : 1;
                    $data['is_expiry'] = ($excelsheet[35] == 'N') ? 0 : 1;
                    $data['created'] = date('Y-m-d');
                    $res[] = DB::table('inventory_rawmaterial')->where('item_code',$excelsheet[1])->update($data);
                    $res[] = 1;
                }
                
            }
    
        }
        if($res)
        return 1;
        else 
        return 0;
    }
    function identify_id($data,$type)
    {
        if($type=='ITEM TYPE'){
           return DB::table('inv_item_type')->where('type_name',$data)->first()->id;
        }
        if($type=='ITEM TYPE 2'){
           return DB::table('inv_item_type_2')->where('type_name',$data)->first()->id;
        }
        if($type=='RECEIPT UNIT'){
         return   DB::table('inv_unit')->where('unit_name',$data)->first()->id;
        }
    
        if($type=='ISSUE UNIT')
        {
            return   DB::table('inventory_rawmaterial_issue_unit')->where('unit_name',$data)->first()->id;
        }
        if($type=='STOCK KEEPING UNIT')
        {
            return   DB::table('inventory_rawmaterial_stock_keeping_unit')->where('unit_name',$data)->first()->id;
        }
    }

    public function fixedRateList(Request $request)
    {
       // dd('hi');
        $condition = [];
        if ($request->item_code) {
            $condition[] = ['inventory_rawmaterial.item_code','like', '%' . $request->item_code . '%'];
        }
        if ($request->supplier) {
            $condition[] = ['inv_supplier.vendor_name','like', '%' . $request->supplier . '%'];
        }
        $data['items'] = inv_supplier_itemrate::select('inv_supplier_itemrate.*','inventory_rawmaterial.item_code','inv_supplier.vendor_name','inventory_gst.igst','inventory_gst.cgst','inventory_gst.sgst','currency_exchange_rate.currency_code')
                                        ->leftJoin('inventory_rawmaterial','inventory_rawmaterial.id','=','inv_supplier_itemrate.item_id')
                                        ->leftJoin('inv_supplier','inv_supplier.id','=','inv_supplier_itemrate.supplier_id')
                                        ->leftJoin('inventory_gst','inventory_gst.id','=','inv_supplier_itemrate.gst')
                                        ->leftJoin('currency_exchange_rate','currency_exchange_rate.currency_id','=','inv_supplier_itemrate.currency')
                                        ->where($condition)
                                        ->orderBy('inv_supplier_itemrate.id','DESC')
                                        ->paginate(15);
        return view('pages/row-material/fixed-rate-list',compact('data'));
    }

    public function getfixedRateUpload()
    {
        return view('pages/row-material/fixed-rate-list-upload');
    }
    public function fixedRateItemUpload(Request $request)
    {
        $file = $request->file('file');
        if ($file) 
        {

            $ExcelOBJ = new \stdClass();
            // CONF
            $path = storage_path().'/app/'.$request->file('file')->store('temp');
            $ExcelOBJ->inputFileName = $path;
            $ExcelOBJ->inputFileType = 'Xlsx';
            // $ExcelOBJ->filename = 'Book1.xlsx';
            // $ExcelOBJ->inputFileName = 'C:\xampp7.4\htdocs\mel\sampleData\Book1.xlsx';
            $ExcelOBJ->spreadsheet = new Spreadsheet();
            $ExcelOBJ->reader = \PhpOffice\PhpSpreadsheet\IOFactory::createReader($ExcelOBJ->inputFileType);
            $ExcelOBJ->reader->setReadDataOnly(true);
            $ExcelOBJ->worksheetData = $ExcelOBJ->reader->listWorksheetInfo($ExcelOBJ->inputFileName);
            $no_column = 15;
            $sheet1_column_count = $ExcelOBJ->worksheetData[0]['totalColumns'];
            //  echo $sheet1_column_count;
            //  exit;
            
            if($sheet1_column_count == $no_column)
            {
                 $res = $this->Excelsplitsheet($ExcelOBJ);
                 //print_r($res);exit;
                 if($res==1)
                 {
                    $request->session()->flash('success',  "Successfully uploaded.");
                    return redirect('row-material/fixed-rate/upload');
                 }
                 else{
                    $request->session()->flash('error',  "The data already uploaded.");
                    return redirect('row-material/fixed-rate/upload');
                 }
            }
            else 
            {
                $request->session()->flash('error',  "Column not matching.. Please download the excel template and check the column count");
                return redirect('row-material/fixed-rate/upload');
            }
            
            //dd($ExcelOBJ->worksheetData);
            //exit;
        }
    }
    public function applyChanges(Request $request)
    {
        $selectedItems = $request->input('selected_items', []); // Fetch selected items
        $activationDate = $request->input('activation_date');
    
        if (empty($selectedItems)) {
            return redirect()->back()->with('error', 'No items selected!');
        }
    
        // Ensure each ID is separate by splitting the string correctly
        if (is_array($selectedItems) && count($selectedItems) === 1) {
            $selectedItems = explode(',', $selectedItems[0]); // Convert "3887,3883,3882" into an array
        }
    
        // Debugging: Print the array to verify the correct format
       // dd($selectedItems); 
    
        // Update the rate_expiry_enddate for all selected items
        inv_supplier_itemrate::whereIn('id', $selectedItems)->update(['rate_expiry_enddate' => $activationDate]);
    
        return redirect()->back()->with('success', 'Activation date updated successfully!');
    }
    

    public function Excelsplitsheet($ExcelOBJ)
    {
        $ExcelOBJ->SQLdata = [];
        $ExcelOBJ->arrayinc = 0;
        foreach ($ExcelOBJ->worksheetData as $key => $worksheet) 
        {
            $ExcelOBJ->sectionName = '';
            $ExcelOBJ->sheetName = $worksheet['worksheetName'];
            $ExcelOBJ->reader->setLoadSheetsOnly($ExcelOBJ->sheetName);
            $ExcelOBJ->spreadsheet = $ExcelOBJ->reader->load($ExcelOBJ->inputFileName);
            $ExcelOBJ->worksheet = $ExcelOBJ->spreadsheet->getActiveSheet();
            $ExcelOBJ->excelworksheet = $ExcelOBJ->worksheet->toArray();
            //print_r(json_encode($ExcelOBJ->excelworksheet));
            $ExcelOBJ->date_created = date('Y-m-d H:i:s');
            $ExcelOBJ->sheetname = $ExcelOBJ->sheetName;
            $res = $this->insert_fixed_item($ExcelOBJ);
            return $res;
        }
        //print_r($res);exit;
       // exit;
    }

    function insert_fixed_item($ExcelOBJ)
    {
        $data = [];
        foreach ($ExcelOBJ->excelworksheet as $key => $excelsheet) 
        {
            if ($key > 1 &&  $excelsheet[1]) 
            {
                $item_id = DB::table('inventory_rawmaterial')->where('item_code','=' ,$excelsheet[2])->pluck('id')->first();
                if($item_id)
                {
                    $res= DB::table('inventory_rawmaterial')->where('id', $item_id)
                    ->update([
                        'hsn_code' => $excelsheet[3]
                        ]);
                }
                 $supplier_id = DB::table('inv_supplier')->where('vendor_id','=' ,$excelsheet[6])->pluck('id')->first();
                //$gst = DB::table('inventory_gst')->where('cgst',trim($excelsheet[9],"%")*100)->where('sgst',trim($excelsheet[10],"%")*100)->where('igst',trim($excelsheet[11],"%")*100)->pluck('id')->first();
                $gst = DB::table('inventory_gst')->where('cgst',$excelsheet[9])->where('sgst',$excelsheet[10])->where('igst',$excelsheet[11])->pluck('id')->first();
                $inv_supplier_itemrate =  DB::table('inv_supplier_itemrate')->select(['*'])->where('item_id', $item_id)->where('supplier_id', $supplier_id)->first();
                $currency = DB::table('currency_exchange_rate')->where('currency_code',$excelsheet[12])->pluck('currency_id')->first();
                if(!($inv_supplier_itemrate))
                {
                    $data = [
                            'supplier_id' =>$supplier_id,
                            'item_id' =>$item_id,
                            'rate'=>$excelsheet[7],
                            //'discount'=>trim($excelsheet[8],"%"),
                            'discount'=>$excelsheet[8]*100, 
                            'gst'=>$gst,
                            'currency'=>$currency,
                            'is_active'=>1,
                            'created_at'=>date('Y-m-d H:i:s'),
                            'updated_at'=>date('Y-m-d H:i:s'),
                            'delivery_within' => 30,
                            //'rate_expiry_startdate'=>($excelsheet[13]!="") ? (\PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject(intval($excelsheet[13]))->format('Y-m-d')) : NULL,
                           // 'rate_expiry_enddate'=>($excelsheet[14]!="") ? (\PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject(intval($excelsheet[14]))->format('Y-m-d')) : NULL,
                           'rate_expiry_startdate'=>date('Y-m-d',strtotime('01-01-2023')),
                           'rate_expiry_enddate'=>date('Y-m-d',strtotime('31-03-2024'))
                    ];
                    $res = DB::table('inv_supplier_itemrate')->insert($data);
               }
               else
               {
                //echo $inv_supplier_itemrate->id;exit;
                    $data = [
                        //'supplier_id' =>$supplier_id,
                        //'item_id' =>$item_id,
                        'rate'=>$excelsheet[7],
                        //'discount'=>trim($excelsheet[8],"%"),
                        'discount'=>$excelsheet[8]*100, 
                        'gst'=>$gst,
                        'currency'=>$currency,
                        'is_active'=>1,
                        'created_at'=>date('Y-m-d H:i:s'),
                        'updated_at'=>date('Y-m-d H:i:s'),
                        'delivery_within' => 30,
                        //'rate_expiry_startdate'=>($excelsheet[13]!="") ? (\PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject(intval($excelsheet[13]))->format('Y-m-d')) : NULL,
                        //'rate_expiry_enddate'=>($excelsheet[14]!="") ? (\PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject(intval($excelsheet[14]))->format('Y-m-d')) : NULL,
                        'rate_expiry_startdate'=>date('Y-m-d',strtotime('01-01-2023')),
                        'rate_expiry_enddate'=>date('Y-m-d',strtotime('31-03-2024'))

                    ];
                    //print_r(json_encode($data));exit;
                    $res = DB::table('inv_supplier_itemrate')->where('id','=',$inv_supplier_itemrate->id)->update($data);
                    // $res[] = inv_supplier_itemrate::where('inv_supplier_itemrate.id','=',$inv_supplier_itemrate->id)
                    //                                 ->update(['
                    //                                     'rate'=>$excelsheet[7],
                    //                                     'discount'=>trim($excelsheet[8],"%"),
                    //                                     'gst'=>$gst,
                    //                                     'currency'=>$currency,
                    //                                     'updated_at'=>date('Y-m-d H:i:s'),
                    //                                     'delivery_within' => 30,
                    //                                 ]);
               }
            }
         
        }
        if($res)
        return 1;
        else 
        return 0;
    }
    public function fixedRateAdd(Request $request)
    {
        if ($request->isMethod('post')) {
            $validation['supplier'] = ['required'];
            $validation['item_code'] = ['required'];
            $validation['rate'] = ['required'];
            // $validation['gst'] = ['required'];
            $validation['discount'] = ['required'];
            $validation['currency'] = ['required'];
            $validation['delivery_within'] = ['required'];

            $validator = Validator::make($request->all(), $validation);
            if (!$validator->errors()->all()) {
                $data['supplier_id'] = $request->supplier;
                $data['item_id'] = $request->item_code;
                $data['rate'] = $request->rate;
                // $data['igst'] = $request->igst;
                // $data['cgst'] = $request->cgst;
                $data['currency'] = $request->currency;
                $data['discount'] = $request->discount;
                $data['delivery_within'] = $request->delivery_within;
                $data['rate_expiry_startdate'] = date('Y-m-d', strtotime($request->expiry_date_start));
                $data['rate_expiry_enddate'] = date('Y-m-d', strtotime($request->expiry_date_end));
                $data['gst'] = DB::table('inventory_gst')->where('cgst', $request->cgst)->where('sgst', $request->sgst)->where('igst', $request->igst)->pluck('id')->first();

                $inv_row = inv_supplier_itemrate::where('supplier_id', $request->supplier)
                    ->where('item_id', $request->item_code)->first();
                if ($inv_row) {

                    $request->session()->flash('error', "Inventory Exist");
                    return redirect('row-material/fixed-rate');
                } else {
                    $add = inv_supplier_itemrate::insertGetId($data);
                    if ($add) {
                        $request->session()->flash('success',  "Successfully Added.");
                        return redirect('row-material/fixed-rate');
                    } else {
                        $request->session()->flash('error',  "Can't Added.");
                        return redirect('row-material/fixed-rate');
                    }
                }
            } else {
                return redirect('row-material/fixed-rate')->withErrors($validator)->withInput();
            }
        } else {
            $currency =  $this->currency_exchange_rate->get_currency([]);
            return view('pages/row-material/fixed-rate-add', compact('currency'));
        }
    }
    public function fixedRateEdit(Request $request, $id)
    {
        if ($request->isMethod('post')) {
            $data['rate'] = $request->rate;
            // $data['gst'] = $request->gst;
            $data['discount'] = $request->discount;
            $data['delivery_within'] = $request->delivery_within;
            $data['rate_expiry_startdate'] = date('Y-m-d', strtotime($request->expiry_date_start));
            $data['rate_expiry_enddate'] = date('Y-m-d', strtotime($request->expiry_date_end));
            $data['gst'] = DB::table('inventory_gst')->where('cgst', $request->cgst)->where('sgst', $request->sgst)->where('igst', $request->igst)->pluck('id')->first();

            $add = inv_supplier_itemrate::where('id', $request->id)
                ->update($data);
            if ($add) {
                $request->session()->flash('success',  "Successfully updated.");
                return redirect('row-material/fixed-rate');
            } else {
                $request->session()->flash('error',  "Can't update.");
                return redirect('row-material/fixed-rate');
            }
        } else {

            $fixed_row_material = inv_supplier_itemrate::select(
                'inv_supplier_itemrate.*',
                'inv_supplier.id as supl_id',
                'inv_supplier.vendor_name',
                'inventory_rawmaterial.id as inv_id',
                'inventory_rawmaterial.item_code',
                'inventory_rawmaterial.discription',
                'inventory_gst.igst',
                'inventory_gst.cgst',
                'inventory_gst.sgst',
                'currency_exchange_rate.currency_code'
            )
                ->leftjoin('inv_supplier', 'inv_supplier.id', '=', 'inv_supplier_itemrate.supplier_id')
                ->leftJoin('inventory_gst', 'inventory_gst.id', '=', 'inv_supplier_itemrate.gst')
                ->leftJoin('currency_exchange_rate', 'currency_exchange_rate.currency_id', '=', 'inv_supplier_itemrate.currency')
                ->leftjoin('inventory_rawmaterial', 'inventory_rawmaterial.id', '=', 'inv_supplier_itemrate.item_id')
                ->where('inv_supplier_itemrate.id', $id)->first();

            return view('pages/row-material/fixed-rate-edit', compact('fixed_row_material'));
        }
    }
    public function fixedRatestatus(Request $request, $id, $status)
    {
        if ($status == 1) {
            inv_supplier_itemrate::where('id', $id)
                ->update(['is_active' => 1]);
            $request->session()->flash('success',  "Activated.");
            return redirect('row-material/fixed-rate');
        } elseif ($status == 2) {
            inv_supplier_itemrate::where('id', $id)
                ->update(['is_active' => 2]);
            $request->session()->flash('success',  "Deactivated.");
            return redirect('row-material/fixed-rate');
        }
    }   
       
}
