<?php

namespace App\Models\PurchaseDetails;
use DB;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class inv_mrr_item extends Model
{
    protected $table = 'inv_mrr_item';
    protected $primary_key = 'id';
    protected $guarded = [];
    public $timestamps = false;

    function insert_data($data){
        return $this->insertGetId($data);
    }

    function update_data($condition,$data){
        return $this->where($condition)->update($data);
    }
    public function get_items($condition)
{
    return $this->select(
        'inv_mrr_item.id as id',
        'inv_miq_item.expiry_control',
        'inv_miq_item.expiry_date',
        'inventory_rawmaterial.item_code',
        'inventory_rawmaterial.discription as item_description',
        'inv_item_type.type_name',
        'inv_unit.unit_name',
        'inv_final_purchase_order_item.cancelled_qty',
        'inv_lot_allocation.lot_number',
        'inv_miq_item.value_inr',
        'currency_exchange_rate.currency_code',
        'inv_mac_item.accepted_quantity',
        'inv_purchase_req_item.actual_order_qty as actualqty',
        'inv_final_purchase_order_item.order_qty as actual_order_qty',
        'inv_supplier_invoice_item.rate',
        'inv_supplier_invoice_item.discount',
        'inv_miq_item.conversion_rate',
        'inv_supplier_invoice_item.order_qty as received_qty',
        'inv_mrd_item.rejected_quantity',
        'inv_mrd_item.remarks as rejection_reason',
        'inv_supplier_invoice_item.id as supplier_invoice_item_id',
        'inv_supplier_invoice_item.is_splited_item',
        'inv_supplier_invoice_item.splited_invoice_item_id',

        // direct single-PO fields for this invoice-item
        'inv_final_purchase_order_master.po_number',
        'inv_final_purchase_order_master.po_date',

        // ----- Correlated subqueries: aggregate PO info ONLY for invoice-items under same master
        // PO numbers for the same item_id (and excluding merged items)
        DB::raw("(
            SELECT GROUP_CONCAT(DISTINCT pm2.po_number ORDER BY pm2.po_number SEPARATOR ', ')
            FROM inv_supplier_invoice_rel r2
            JOIN inv_supplier_invoice_item si2 ON si2.id = r2.item
            JOIN inv_final_purchase_order_master pm2 ON pm2.id = si2.po_master_id
            WHERE r2.master = rel_current.master
              AND si2.item_id = inv_supplier_invoice_item.item_id
              AND (si2.is_merged IS NULL OR si2.is_merged != 2)
        ) as po_numbers"),

        // PO dates for the same item_id
        DB::raw("(
            SELECT GROUP_CONCAT(DISTINCT DATE_FORMAT(pm2.po_date, '%d-%m-%Y') ORDER BY pm2.po_date SEPARATOR ', ')
            FROM inv_supplier_invoice_rel r2
            JOIN inv_supplier_invoice_item si2 ON si2.id = r2.item
            JOIN inv_final_purchase_order_master pm2 ON pm2.id = si2.po_master_id
            WHERE r2.master = rel_current.master
              AND si2.item_id = inv_supplier_invoice_item.item_id
              AND (si2.is_merged IS NULL OR si2.is_merged != 2)
        ) as po_dates"),

        // aggregated PO qtys (order_qty + cancelled_qty) for the same item_id,
        // unit name is taken from the outer join (inventory_rawmaterial -> inv_unit)
        DB::raw("(
            SELECT GROUP_CONCAT(DISTINCT CONCAT(pi2.order_qty + pi2.cancelled_qty, ' ', inv_unit.unit_name) SEPARATOR ', ')
            FROM inv_supplier_invoice_rel r2
            JOIN inv_supplier_invoice_item si2 ON si2.id = r2.item
            JOIN inv_final_purchase_order_item pi2 ON pi2.id = si2.po_item_id
            WHERE r2.master = rel_current.master
              AND si2.item_id = inv_supplier_invoice_item.item_id
              AND (si2.is_merged IS NULL OR si2.is_merged != 2)
        ) as all_po_qtys"),

        // debug: which master/item ids were included in aggregation
        DB::raw("(
            SELECT GROUP_CONCAT(DISTINCT si2.po_master_id ORDER BY si2.po_master_id SEPARATOR ',')
            FROM inv_supplier_invoice_rel r2
            JOIN inv_supplier_invoice_item si2 ON si2.id = r2.item
            WHERE r2.master = rel_current.master
              AND si2.item_id = inv_supplier_invoice_item.item_id
              AND (si2.is_merged IS NULL OR si2.is_merged != 2)
        ) as po_master_ids"),
        DB::raw("(
            SELECT GROUP_CONCAT(DISTINCT si2.po_item_id ORDER BY si2.po_item_id SEPARATOR ',')
            FROM inv_supplier_invoice_rel r2
            JOIN inv_supplier_invoice_item si2 ON si2.id = r2.item
            WHERE r2.master = rel_current.master
              AND si2.item_id = inv_supplier_invoice_item.item_id
              AND (si2.is_merged IS NULL OR si2.is_merged != 2)
        ) as po_item_ids")
    )

    // base joins
    ->leftJoin('inv_mrr_item_rel', 'inv_mrr_item_rel.item', '=', 'inv_mrr_item.id')
    ->leftJoin('inv_mac_item', 'inv_mac_item.invoice_item_id', '=', 'inv_mrr_item.invoice_item_id')
    ->leftJoin('inv_supplier_invoice_item', 'inv_supplier_invoice_item.id', '=', 'inv_mrr_item.invoice_item_id')
    ->leftJoin('inv_miq_item', 'inv_miq_item.invoice_item_id', '=', 'inv_supplier_invoice_item.id')
    ->leftJoin('inv_mrd_item', 'inv_mrd_item.invoice_item_id', '=', 'inv_supplier_invoice_item.id')

    // we still need rel_current.master to know which invoice-master we're aggregating from
    ->leftJoin('inv_supplier_invoice_rel as rel_current', 'rel_current.item', '=', 'inv_supplier_invoice_item.id')

    // direct PO join for the invoice-item (single PO fields)
    ->leftJoin('inv_final_purchase_order_master', 'inv_final_purchase_order_master.id', '=', 'inv_supplier_invoice_item.po_master_id')
    ->leftJoin('inv_final_purchase_order_item', 'inv_final_purchase_order_item.id', '=', 'inv_supplier_invoice_item.po_item_id')

    // other base joins
    ->leftJoin('inv_purchase_req_item', 'inv_purchase_req_item.requisition_item_id', '=', 'inv_supplier_invoice_item.item_id')
    ->leftJoin('inventory_rawmaterial', 'inventory_rawmaterial.id', '=', 'inv_purchase_req_item.item_code')
    ->leftJoin('inv_item_type', 'inv_item_type.id', '=', 'inventory_rawmaterial.item_type_id')
    ->leftJoin('inv_lot_allocation', 'inv_lot_allocation.si_invoice_item_id', '=', 'inv_supplier_invoice_item.id')
    ->leftJoin('inv_unit', 'inv_unit.id', '=', 'inventory_rawmaterial.issue_unit_id')
    ->leftJoin('currency_exchange_rate', 'currency_exchange_rate.currency_id', '=', 'inv_miq_item.currency')

    ->where($condition)
    ->orderBy('inv_mrr_item.id', 'DESC')
    ->groupBy('inv_mrr_item.id')
    ->get();
}

    
    
    
    
    
    
}
