@extends('layouts.default')
@section('content') 
 <div class="az-content az-content-dashboard">
  <br>
    <div class="container">
        <div class="az-content-body">

            <div class="az-content-breadcrumb"> 
                <span><a href="" style="color: #596881;"> CANCELLATION MATERIAL ISSUE NOTE (CMIN) </a></span> 
                <!-- <span><a href="" style="color: #596881;">MRN</a></span> -->
                <span><a href="">
                   
                </a></span>
            </div>
    
            <h4 class="az-content-title" style="font-size: 20px;margin-bottom: 18px !important;">
            CANCELLATION MATERIAL ISSUE NOTE (CMIN) 
            </h4>
                    <button style="float: right;font-size: 14px;" onclick="document.location.href='{{url('fgs/manual-CMIN')}}'" class="badge badge-pill badge-dark "><i class="fas fa-plus"></i> 
                    Manual CMIN
                    </button>
            <div class="az-dashboard-nav">
           
            </div>

            <div class="row">
                    
                <div class="col-sm-12   col-md-12 col-lg-12 col-xl-12 " style="border: 0px solid rgba(28, 39, 60, 0.12);">
                @if(Session::get('error'))
                <div class="alert alert-danger "  role="alert" style="width: 100%;">
                    <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                    {{Session::get('error')}}
                </div>
                @endif
                @if (Session::get('success'))
                <div class="alert alert-success " style="width: 100%;">
                    <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                    <i class="icon fa fa-check"></i> {{ Session::get('success') }}
                </div>
                @endif
                @foreach ($errors->all() as $errorr)
                <div class="alert alert-danger "  role="alert" style="width: 100%;">
                    <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                        {{ $errorr }}
                </div>
                 @endforeach 
                 <form method="POST" id="commentForm" autocomplete="off">
    {{ csrf_field() }}

    <div class="row">
        <div class="form-group col-12" style="margin: 0px;">
            <label style="color: #3f51b5; font-weight: 500; margin-bottom:2px;">
                <i class="fas fa-address-card"></i> Basic details
            </label>
            <div class="form-devider"></div>
        </div>
    </div>

    <div class="row">
        {{-- MIN Number --}}
        <div class="form-group col-md-4">
            <label>MIN number *</label>
            @php
                $min_number_value = old('min_number') ?? ($edit['min']->min_number ?? '');
            @endphp

            <select class="form-control min_number" name="min_number" @if(!empty($edit['min'])) disabled @endif>
                <option value="">-- Select MIN --</option>
                @if(!empty($edit['min']))
                    <option value="{{ $edit['min']->min_number }}" selected>{{ $edit['min']->min_number }}</option>
                @endif
            </select>

            {{-- Hidden input to send value if select is disabled --}}
            @if(!empty($edit['min']))
                <input type="hidden" name="min_number" value="{{ $edit['min']->min_number }}">
            @endif
        </div>

        {{-- CMIN Date --}}
        <div class="form-group col-md-4">
            <label>CMIN date *</label>
            <input type="text" class="form-control datepicker" 
                   value="{{ old('cmin_date', date('d-m-Y')) }}" 
                   name="cmin_date" placeholder="CMIN date">
        </div>

        {{-- Created By --}}
        <div class="form-group col-md-4">
            <label>Created by *</label>
            <select class="form-control user_list" name="created_by" required>
                @foreach ($data['users'] as $user)
                    <option value="{{ $user->user_id }}" 
                        @if(old('created_by', $edit['min']->created_by ?? '') == $user->user_id) selected @endif>
                        {{ $user->f_name }} {{ $user->l_name }}
                    </option>
                @endforeach
            </select>
        </div>

        {{-- Stock Location --}}
        <div class="form-group col-md-4">
            <label>Stock Location Increase*</label>
            @php
                $stock_value = old('stock_location') ?? ($edit['min']->stock_location ?? '');
            @endphp
            <select class="form-control" name="stock_location" required @if(!empty($edit['min'])) disabled @endif>
                <option value="">-- Select Stock Location --</option>
                @foreach($stock_locations as $location)
                    <option value="{{ $location->id }}" @if($stock_value == $location->id) selected @endif>
                        {{ $location->location_name }}
                    </option>
                @endforeach
            </select>
            @if(!empty($edit['min']))
                <input type="hidden" name="stock_location" value="{{ $edit['min']->stock_location }}">
            @endif
        </div>
    </div>

    {{-- Items Section --}}
    @if(!empty($edit['items']))
        <div class="row">
            @foreach($edit['items'] as $item)
                <input type="hidden" name="invoice_item[{{ $loop->index }}][sku_code]" value="{{ $item->sku_code }}">
                <input type="hidden" name="invoice_item[{{ $loop->index }}][discription]" value="{{ $item->discription }}">
                <input type="hidden" name="invoice_item[{{ $loop->index }}][batch_no]" value="{{ $item->batch_no }}">
                <input type="hidden" name="invoice_item[{{ $loop->index }}][quantity]" value="{{ $item->quantity }}">
            @endforeach
        </div>
    @endif

    {{-- Data bindings for AJAX MIN info --}}
    <div class="data-bindings" style="width:100%;"></div>

    <div class="row mt-3">
        <div class="col-12">
            <button type="submit" class="btn btn-primary spinner-button">Save CMIN</button>
        </div>
    </div>
</form>

            </div>   
        </div>
    </div>
        <!-- az-content-body -->
    </div>

    <script src="<?=url('');?>/js/azia.js"></script>
    <script src="<?= url('') ?>/lib/bootstrap/js/bootstrap.bundle.min.js">  </script>
    <script src="<?= url('') ?>/lib/select2/js/select2.min.js"></script>
    <script src="<?= url('') ?>/lib/amazeui-datetimepicker/js/bootstrap-datepicker.js"></script>
    <script src="<?= url('') ?>/lib/jquery.maskedinput/jquery.maskedinput.js"></script>
    <script src="<?= url('') ?>/js/jquery.validate.js"></script>
    <script src="<?= url('') ?>/js/additional-methods.js"></script>
    <script>
        $(document).ready(function() {
            $('form').submit(function() {
                $(this).find(':submit').prop('disabled', true);
            });
        });
      $(function(){
        'use strict'

        $("#commentForm").validate({
        rules: {
            miq_number: {
                required: true,
            },
            mac_date:{
                required: true,
            },
            created_by:{
                required: true,
            }

        },
        submitHandler: function(form) {
            $('.spinner-button').show();
            form.submit();
        }
    });


    $('.user_list').select2({
          placeholder: 'Choose one',
          searchInputPlaceholder: 'Search',

      });


      });

    $(".datepicker").datepicker({
    format: " dd-mm-yyyy",
    autoclose:true,
    endDate: new Date()
    });
    $('.datepicker').mask('99-99-9999');
    
    $(".manufacturing_date").datepicker({
                        format: " dd-mm-yyyy",
                        autoclose:true,
                        endDate: new Date()
                    });

    $('.datepicker').mask('99-99-9999');

    $('.min_number').select2({
          placeholder: 'Choose one',
          searchInputPlaceholder: 'Search',
          minimumInputLength: 2,
          allowClear: true,
          ajax: {
          url: "{{ url('fgs/CMIN/find-min-number-for-cmin') }}",
          processResults: function (data) {
            return { results: data };

          }
        }
      }).on('change', function (e) {
        $('.spinner-button').show();

        let res = $(this).select2('data')[0];
        if(res){
          $.get("{{ url('fgs/CMIN/find-min-info') }}?id="+res.id,function(data){
            $('.data-bindings').html(data);
            $('.spinner-button').hide();
          });
        }else{
          $('.data-bindings').html('');
          $('.spinner-button').hide();
        }
      });
    //check all
    function toggleCheckboxes(headerCheckbox) {
            $('.rowCheckbox').prop('checked', headerCheckbox.checked);
            enableTextBox();
        }

        function enableTextBox() {
            const checkedCheckboxes = $('.rowCheckbox:checked');

            // Enable/disable qty_to_cancel inputs based on the number of checkboxes checked
            $('.qty_to_cancel').each(function() {
                const $row = $(this).closest('tr');
                const $checkbox = $row.find('.rowCheckbox');

                if ($checkbox.is(':checked') || checkedCheckboxes.length === 0) {
                    $(this).prop('disabled', false).prop('required', true);
                    $(this).parent("td").next("td").children('.manufacturing_date').attr('disabled',false);
                    // Set max attribute for qty_to_cancel based on the checked checkbox
                    if (checkedCheckboxes.length >1) {
                        $(this).attr('max', function() {
                            return $row.find('td:eq(4)').text().replace('Nos', '').trim();
                        });

                        // Copy the value from "QUANTITY" to "QUANTITY TO CANCEL"
                        const quantityValue = $row.find('td:eq(4)').text().replace('Nos', '').trim();
                        $(this).val(quantityValue);
                    } else {
                        $(this).removeAttr('max').val('').prop('required', false);
                    }
                } else {
                    $(this).val('').prop('required', false).prop('disabled', true);
                    $(this).parent("td").next("td").children('.manufacturing_date').attr('disabled',true);
                }
            });
        }

        // Add a click event listener to individual row checkboxes
        $('.rowCheckbox').on('click', function() {
            enableTextBox();
        });

        // Add a click event listener to the "Select All" checkbox
        $('#selectAll').on('click', function() {
            toggleCheckboxes(this);
        });
    
    </script>


@stop
