@extends('layouts.default')

@section('title', 'Edit Invoice Item')

@section('content')
<div class="card">
    <div class="card-header">
        <h5>Edit Invoice Item</h5>
    </div>
    <div class="card-body">
        <form action="{{ url('/invoice/item/update/' . $invoiceId . '/' . $item->id) }}" method="POST">
            @csrf
            <div class="form-group">
                <label for="order_qty">Invoiced Quantity</label>
                <input type="number" name="order_qty" id="order_qty" 
                       value="{{ $item->order_qty }}" class="form-control" step="0.01" required>
            </div>
            <button type="submit" class="btn btn-success">Update</button>
            <a href="{{ url()->previous() }}" class="btn btn-secondary">Cancel</a>
        </form>
    </div>
</div>
@endsection
