@extends('layouts.default')

@section('content')
<div class="container">
    <h3>Partial Invoice Entry</h3>

    <div class="mb-4 p-3 border rounded bg-light">
        <p><strong>Invoice #:</strong> {{ $invoice->invoice_number }}</p>
        <p><strong>Supplier:</strong> {{ $poItem->vendor_name }}</p>
        <p><strong>PO Number:</strong> {{ $poItem->po_number }}</p>
        <p><strong>Item Code:</strong> {{ $poItem->item_code }} - {{ $poItem->short_description }}</p>
        <p><strong>Ordered Qty:</strong> {{ number_format($poItem->order_qty, 2) }} {{ $poItem->unit_name }}</p>
        <!-- <p><strong>Pending Qty:</strong> {{ number_format($poItem->pending_qty, 2) }} {{ $poItem->unit_name }}</p> -->
    </div>

    <form action="{{ url('invoice/partial/' . $invoice->id) }}" method="POST">
        @csrf
        <input type="hidden" name="invoice_id" value="{{ $invoice->id }}">
        <input type="hidden" name="po_item_id" value="{{ $poItem->id }}">

        <div class="form-group">
            <label for="qty">Quantity to Invoice</label>
            <input type="number" name="qty" step="0.01" max="{{ $poItem->pending_qty }}" class="form-control" required>
        </div>

        <button type="submit" class="btn btn-primary">Add Item</button>
        <a href="{{ url()->previous() }}" class="btn btn-secondary">Back</a>
    </form>
</div>
@endsection
