@extends('layouts.default')
@section('content')

<h5>Invoice Summary</h5>

{{-- PO Items Section --}}
<h5>PO Items (Pending)</h5>
<label for="po-search">Search by PO Number:</label>
<input type="text" id="po-search" placeholder="Enter PO Number" class="form-control" style="width: 250px; margin-bottom: 10px;">
<label for="item-search">Search by Item Code:</label>
<input type="text" id="item-search" placeholder="Enter Item Code" 
       class="form-control" style="width: 250px; margin-bottom: 10px;">
<table class="table table-bordered" id="po-items-table">
    <thead>
        <tr>
            <th>PO Number</th>
            <th>Item Code</th>
            <th>Type</th>
            <th>Total Order Quantity</th>
            <th>Pending Quantity</th>
            <th>Item Description</th>
            <th>Rate</th>
            <th>Discount</th>
            <th>GST</th>
            <th>Supplier</th>
            <th>Action</th>
        </tr>
    </thead>
    <tbody>
        @foreach($poItems as $item)
        <tr class="po-item-row {{ $item->qty_to_invoice < $item->order_qty ? 'table-warning' : '' }}" data-item-id="{{ $item->id }}">
            <td>{{ $item->po_number }}</td>
            <td>{{ $item->item_code }}</td>
            <td>{{ $item->type }}</td>
            <td>{{$item->order_qty}}</td>
            <td>{{ number_format($item->qty_to_invoice, 2) }} {{ $item->unit_name }}</td>
            <td>{{ $item->short_description }}</td>
            <td>{{ $item->rate }}</td>
            <td>{{ $item->discount }}</td>
            <td>
                @if($item->igst) IGST: {{ $item->igst }}%<br>@endif
                @if($item->cgst) CGST: {{ $item->cgst }}%<br>@endif
                @if($item->sgst) SGST: {{ $item->sgst }}% @endif
            </td>
            <td>{{ $item->vendor_name }}</td>
            <td>
                {{-- Full Invoice --}}
                <form action="{{ url('inventory/supplier-invoice-add-item-save') }}" method="POST" class="add-invoice-form">
                    @csrf
                    <input type="hidden" name="po_item_id" value="{{ $item->id }}">
                    <input type="hidden" name="qty" value="{{ $item->qty_to_invoice }}">
                    <input type="hidden" name="invoice_id" value="{{ request()->route('id') }}">
                    <button type="submit" class="btn btn-success btn-sm">Add Invoice</button>
                </form>

                {{-- Partial Invoice Redirect --}}
                <form action="{{ url('/invoice/partial/' . request()->route('id') . '/' . $item->id) }}" method="GET" style="margin-top: 5px;">
                    <button type="submit" class="btn btn-warning btn-sm">Partial Invoice</button>
                </form>
            </td>
        </tr>
        @endforeach
    </tbody>
</table>

{{-- Invoice Items Section --}}
<h5>Invoice Items</h5>
<table class="table table-bordered" id="invoice-items-table">
    <thead>
        <tr>
            <th>PO Number</th>
            <th>Item Code</th>
            <th>Description</th>
            <th>Qty</th>
            <th>Rate</th>
            <th>Total</th>
            <th>Action</th>
        </tr>
    </thead>
    <tbody>
        @forelse($invoiceItems as $item)
            <tr>
                <td>{{ $item->po_number }}</td>
                <td>{{ $item->item_code }}</td>
                <td>{{ $item->short_description }}</td>
                <td>{{ $item->order_qty }}</td>
                <td>{{ number_format($item->rate, 2) }}</td>
                <td>{{ number_format($item->order_qty * $item->rate, 2) }}</td>
                <td>
                <a href="{{ url('/invoice/item/edit/' . $invoiceId . '/' . $item->id) }}" 
   class="btn btn-primary btn-sm">
   Edit
</a>


</td>

            </tr>
        @empty
            <tr>
                <td colspan="6" class="text-center">No items added to this invoice yet.</td>
            </tr>
        @endforelse
    </tbody>
</table>

<script>
$(document).ready(function() {
    $('#po-search').on('keyup', function() {
        var value = $(this).val().toLowerCase();
        $('#po-items-table tbody tr').filter(function() {
            $(this).toggle($(this).find('td:first').text().toLowerCase().indexOf(value) > -1)
        });
    });
    $('#item-search').on('keyup', function() {
        var value = $(this).val().toLowerCase();
        $('#po-items-table tbody tr').filter(function() {
            $(this).toggle($(this).find('td:eq(1)').text().toLowerCase().indexOf(value) > -1)
        });
    });
});
</script>

@stop
