@extends('layouts.default')
@section('content')

<div class="az-content az-content-dashboard">
  <br>
  <div class="container">
    <div class="az-content-body">
      <div class="az-content-breadcrumb">
        <span><a href="{{ url('inventory/supplier-invoice') }}">Supplier Invoice</a></span>
        <span>Add</span>
      </div>

      <h4 class="az-content-title">Add Supplier Invoice</h4>

      @if (Session::get('success'))
      <div class="alert alert-success">{{ Session::get('success') }}</div>
      @endif

      @if (Session::get('error'))
      <div class="alert alert-danger">{{ Session::get('error') }}</div>
      @endif

      @foreach ($errors->all() as $error)
      <div class="alert alert-danger">{{ $error }}</div>
      @endforeach

      <!-- Search supplier -->
      <form method="GET" action="{{ url('inventory/supplier-invoice-view') }}">
        <div class="form-group">
          <label>Search Supplier</label>
          <input type="text" name="search_supplier" class="form-control" placeholder="Enter supplier name" value="{{ request('search_supplier') }}">
        </div>
        <button type="submit" class="btn btn-primary">Search</button>
      </form>

      @if(count($suppliers) > 0)
      <form method="POST" action="{{ url('inventory/supplier-invoice-submit') }}">
        @csrf

        <div class="form-group mt-4">
          <label>Select Supplier</label>
          <select name="supplier_id" class="form-control" required>
            <option value="">Choose supplier</option>
            @foreach($suppliers as $supplier)
<option value="{{ $supplier->id }}">{{ $supplier->vendor_name }}</option>
            @endforeach
          </select>
        </div>

        <div class="form-group">
          <label>Invoice Number</label>
          <input type="text" name="invoice_number" class="form-control" required>
        </div>

        <div class="form-group">
          <label>Invoice Date</label>
          <input type="date" name="invoice_date" class="form-control" required>
        </div>
    <div class="form-group">
        <label for="order_type">Select Order Type</label>
        <select name="order_type" id="order_type" class="form-control" required>
            <option value="">-- Select Order Type --</option>
            <option value="PO">PO</option>
            <option value="WO">WO</option>
        </select>
    </div>
       
        <div class="form-group">
          <label>Material Receipt Date</label>
          <input type="date" name="material_receipt_date" class="form-control" required>
        </div>
        <button type="submit" class="btn btn-success"><i class="fas fa-save"></i> Save Invoice</button>
      </form>
      @endif

    </div>
  </div>
</div>

@stop
