@extends('layouts.default')
@section('content')
<style>
    input[type="radio"] {
        appearance: none;
        border: 1px solid #d3d3d3;
        width: 30px;
        height: 30px;
        content: none;
        outline: none;
        margin: 0;
        box-shadow: rgba(0, 0, 0, 0.24) 0px 3px 8px;
        background-color: #fff;
    }

    input[type="radio"]:checked::before {
        position: relative;
        color: green !important;
        content: "\00A0\2713\00A0" !important;
        border: 1px solid #d3d3d3;
        font-weight: bolder;
        font-size: 21px;
    }

    .select2-search--inline .select2-search__field {
        width: auto !important;
        min-width: 150px !important;
        max-width: 100% !important;
    }
</style>

<div class="az-content az-content-dashboard">
    <br>
    <div class="container">
        <div class="az-content-body">
            <div class="az-content-breadcrumb">
                <span><a href="#" style="color: #596881;">QUALITY INSPECTION</a></span>
                <span><a href="#">EDIT INSPECTION</a></span>
            </div>
            <h4 class="az-content-title" style="font-size: 20px;margin-bottom: 18px !important;">EDIT QUALITY INSPECTION</h4>

            @if (Session::get('success'))
            <div class="alert alert-success">
                <button type="button" class="close" data-dismiss="alert">×</button>
                {{ Session::get('success') }}
            </div>
            @endif

            @if (Session::get('error'))
            <div class="alert alert-danger">
                <button type="button" class="close" data-dismiss="alert">×</button>
                {{ Session::get('error') }}
            </div>
            @endif

            @foreach ($errors->all() as $error)
            <div class="alert alert-danger">
                <button type="button" class="close" data-dismiss="alert">×</button>
                {{ $error }}
            </div>
            @endforeach

            <form action="{{ url('quality/quality-check/' . $inspection->id) }}" method="POST" autocomplete="off">
                @csrf
                @method('PUT')
                <div class="row">
                    <div class="form-group col-sm-12 col-md-6 col-lg-6 col-xl-6">
                        <label>Batch Creation Date *</label>
                        <input type="text" class="form-control"
                            value="{{ !empty($inspection->start_date) ? date('Y-m-d', strtotime($inspection->start_date)) : '' }}" name="batch_creation_date"
                            placeholder="Start Date"
                            readonly>
                    </div>

                    <div class="form-group col-sm-12 col-md-6 col-lg-6 col-xl-6">
                        <label>Batch Card No *</label>
                        <input type="text" class="form-control" value="{{$inspection->batch_no ?? 'N/A'}}" name="batch_no" placeholder="Batch Card No" readonly>
                    </div><!-- form-group -->
                    <div class="form-group col-sm-12 col-md-6 col-lg-6 col-xl-6">
                        <label>SKU code *</label>
                        <textarea value="" class="form-control" name="sku_name" placeholder="SKU Code" readonly>{{$inspection->sku_name ?? 'N/A'}}</textarea>
                    </div><!-- form-group -->
                    <div class="form-group col-sm-12 col-md-6 col-lg-6 col-xl-6">
                        <label>Item Description *</label>
                        <textarea value="" class="form-control" name="description" placeholder="Description" readonly>{{$inspection->description ?? 'N/A'}}</textarea>

                    </div><!-- form-group -->
                    <div class="form-group col-sm-12 col-md-6 col-lg-6 col-xl-6">
                                            <label>Product Group *</label>
                                            <input type="text" class="form-control"  value="{{$inspection->product_group ?? 'N/A'}}" name="product_group" placeholder="Product Group" readonly>
                                        </div>
                   
                  <div class="form-group col-sm-12 col-md-6 col-lg-6 col-xl-6">
    <label>Material Lot No*</label>

    @php
        $selected_batches = !empty($inspection->material_lot_no) ? explode(',', $inspection->material_lot_no) : [];
    @endphp

    <select class="form-control batchcard_no" name="material_lot_no[]" id="batchcard_no" multiple="multiple" required>
        @foreach ($selected_batches as $batch)
            <option value="{{ $batch }}" selected>{{ $batch }}</option>
        @endforeach
    </select>
</div>

                    <div class="form-group col-sm-12 col-md-6 col-lg-6 col-xl-6">
                        <label>QC Inward Date *</label>
                        <input type="date" class="form-control"
                            value="{{ !empty($inspection->inward_doc_date) ? date('Y-m-d', strtotime($inspection->inward_doc_date)) : '' }}"
                            name="inward_doc_date"
                            placeholder="Inward doc Date">
                    </div>
                    <div class="row">
                        <div class="form-group col-md-6">
                            <label>Inspection Start Date *</label>
                            <input type="date" name="start_date" class="form-control"
                                value="{{ old('start_date', $inspection->start_date) }}" required>
                        </div>

                        <div class="form-group col-md-6">
                            <label>Inspection Start Time *</label>
                            <input type="time" name="start_time" class="form-control"
                                value="{{ old('start_time', $inspection->start_time) }}" required>
                        </div>

                        <div class="form-group col-md-6">
                            <label>Inspection End Date *</label>
                            <input type="date" name="end_date" class="form-control"
                                value="{{ old('end_date', $inspection->end_date) }}" required>
                        </div>

                        <div class="form-group col-md-6">
                            <label>Inspection End Time *</label>
                            <input type="time" name="end_time" class="form-control"
                                value="{{ old('end_time', $inspection->end_time) }}">
                        </div>

                        <div class="form-group col-md-6">
                            <label>Inspected Qty *</label>
                            <input type="text" name="inspected_qty" class="form-control"
                                value="{{ old('inspected_qty', $inspection->inspected_qty) }}" required>
                        </div>

                        <div class="form-group col-md-6">
                            <label>Accepted Qty *</label>
                            <input type="text" name="accepted_quantity" id="accepted_quantity" class="form-control"
                                value="{{ old('accepted_quantity', $inspection->accepted_quantity) }}" required>
                        </div>

                        <div class="form-group col-md-6">
                            <label>Rejected Qty</label>
                            <input type="text" name="rejected_qty" id="rejected_qty" class="form-control"
                                value="{{ old('rejected_qty', $inspection->rejected_qty) }}">
                        </div>

                        <div class="form-group col-md-6" id="rejected_reason_container" style="{{ old('rejected_qty', $inspection->rejected_qty) > 0 ? '' : 'display: none;' }}">
                            <label>Rejected Reason</label>
                            <textarea name="rejected_reason" class="form-control">{{ old('rejected_reason', $inspection->rejected_reason) }}</textarea>
                        </div>

                        <div class="form-group col-md-6">
                            <label>Rework Qty *</label>
                            <input type="text" name="rework_quantity" id="rework_quantity" class="form-control"
                                value="{{ old('rework_quantity', $inspection->rework_quantity ?? 0) }}" required>
                        </div>

                        <div class="form-group col-md-6" style="{{ old('rework_quantity', $inspection->rework_quantity) > 0 ? '' : 'display: none;' }}">
                            <label>Rework Reason</label>
                            <textarea name="rework_reason" class="form-control">{{ old('rework_reason', $inspection->rework_reason) }}</textarea>
                        </div>

                        <div class="form-group col-md-6">
                            <label>Remaining Qty *</label>
                            <input type="text" name="remaining_quantity" id="remaining_quantity" class="form-control"
                                value="{{ old('remaining_quantity', $inspection->remaining_quantity ?? 0) }}" required>
                        </div>

                        <div class="form-group col-md-6" id="remaining_reason_container" style="{{ old('remaining_quantity', $inspection->remaining_quantity) > 0 ? '' : 'display: none;' }}">
                            <label>Remaining Reason</label>
                            <textarea name="remaining_reason" class="form-control">{{ old('remaining_reason', $inspection->remaining_reason) }}</textarea>
                        </div>

                        <div class="form-group col-md-6">
                            <label>Accepted Qty with deviation</label>
                            <input type="text" name="accepted_quantity_with_deviation" class="form-control"
                                value="{{ old('accepted_quantity_with_deviation', $inspection->accepted_quantity_with_deviation) }}">
                        </div>

                        <div class="form-group col-md-6" style="{{ !empty($inspection->accepted_quantity_with_deviation) ? '' : 'display: none;' }}">
                            <label>Reason for deviation</label>
                            <textarea name="reason_for_deviation" class="form-control">{{ old('reason_for_deviation', $inspection->reason_for_deviation) }}</textarea>
                        </div>

                        <div class="form-group col-md-6">
                            <label>Pending Status *</label>
                            <select name="pending_status" class="form-control" required>
                                <option value="0" {{ old('pending_status', $inspection->pending_status) == 0 ? 'selected' : '' }}>Pending</option>
                                <option value="1" {{ old('pending_status', $inspection->pending_status) == 1 ? 'selected' : '' }}>Settled</option>
                            </select>
                        </div>

                        <div class="form-group col-md-6">
                            <label>Remarks *</label>
                            <textarea name="remark" class="form-control" required>{{ old('remark', $inspection->remark) }}</textarea>
                        </div>

                        <div class="form-group col-md-6">
                            <label>Inspector Name *</label>
                            <select class="form-control inspector" name="inspector_name[]" multiple="multiple" required>
                                @php
                                $selectedInspectors = explode(',', $inspection->inspector_name);
                                @endphp
                                <option value="">--- select one ---</option>
                                @foreach(['Satyawan Jadhav','Ganesh Bothare','Sumit Vele','Mahesh Bandagle','Santosh Gopal','Ravindra Zepale','Pravin Sawant','Ramesh Patere','Prasad Sawant','Rupesh Kirve','Rushikesh Surve','Ashish Salaskar','Amol Mane','Rajendra Ghanekar','Kunal Pawar','Aswin','Chandrakant patere'] as $inspector)
                                <option value="{{ $inspector }}" {{ in_array($inspector, $selectedInspectors) ? 'selected' : '' }}>{{ $inspector }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    <div class="row mt-3">
                        <div class="form-group col-12">
                            <button type="submit" class="btn btn-success float-right">
                                <i class="fas fa-save"></i> Update
                            </button>
                        </div>
                    </div>
            </form>
        </div>
    </div>
</div>
<script src="<?= url('') ?>/js/azia.js"></script>
<script src="<?= url('') ?>/lib/bootstrap/js/bootstrap.bundle.min.js">  </script>
<script src="<?= url('') ?>/js/jquery.validate.js"></script>
<script src="<?= url('') ?>/js/additional-methods.js"></script>
<script src="<?= url('') ?>/lib/amazeui-datetimepicker/js/bootstrap-datepicker.js"></script>
<script src="<?= url('') ?>/lib/ionicons/ionicons.js"></script>
<script src="<?= url('') ?>/lib/jquery.maskedinput/jquery.maskedinput.js"></script>
<script src="<?= url('') ?>/lib/select2/js/select2.min.js"></script>
<script>
   $(document).ready(function () {
    const acceptedQuantityInput = $('#accepted_quantity');
    const rejectedQuantityInput = $('#rejected_qty');
    const reworkQuantityInput = $('#rework_quantity');
    const remainingQuantityInput = $('#remaining_quantity');
    const inspectedQuantityInput = $('input[name="inspected_qty"]');
    const deviationQuantityInput = $('input[name="accepted_quantity_with_deviation"]');
    const endDateInput = $('#pending_status_group'); // Fixed typo
    const pendingStatusSelect = $('select[name="pending_status"]');
    const settledOption = $('.settled_option');

    function updateVisibility() {
        const acceptedQuantity = parseFloat(acceptedQuantityInput.val()) || 0;
        const rejectedQuantity = parseFloat(rejectedQuantityInput.val()) || 0;
        const reworkQuantity = parseFloat(reworkQuantityInput.val()) || 0;
        const remainingQuantity = parseFloat(remainingQuantityInput.val()) || 0;
        const deviationQuantity = parseFloat(deviationQuantityInput.val()) || 0;
        const inspectedQuantity = acceptedQuantity + rejectedQuantity + reworkQuantity + remainingQuantity + deviationQuantity;

        // Update inspected quantity dynamically
        inspectedQuantityInput.val(inspectedQuantity);

        // Show reason containers if respective quantities have values
        $('#rejected_reason_container').toggle(rejectedQuantity > 0);
        $('#rework_reason').closest('.form-group').toggle(reworkQuantity > 0);
        $('#remaining_reason_container').toggle(remainingQuantity > 0);

        // Ensure "Settled" option is selected if end_date exists
        if (endDateInput.val().trim() !== "") {
            pendingStatusSelect.val("1"); // Settled
            settledOption.show();
        } else {
            settledOption.hide();
        }

        // Automatically select "Settled" if total processed equals inspected quantity
        if (inspectedQuantity > 0) {
            pendingStatusSelect.val("1"); // Settled
        } else {
            pendingStatusSelect.val("0"); // Pending
        }
    }

    // Initial check on page load
    updateVisibility();

    // Event listeners for input changes
    acceptedQuantityInput.on('input', updateVisibility);
    rejectedQuantityInput.on('input', updateVisibility);
    reworkQuantityInput.on('input', updateVisibility);
    remainingQuantityInput.on('input', updateVisibility);
    deviationQuantityInput.on('input', updateVisibility);
    endDateInput.on('input', updateVisibility);

    // Show "Reason for Deviation" when "Accepted Qty with Deviation" has a value
    deviationQuantityInput.on('input', function() {
        const acceptedQtyDeviation = $(this).val().trim();
        $('textarea[name="reason_for_deviation"]').closest('.form-group').toggle(!!acceptedQtyDeviation);
    });
});




$('.batchcard_no').select2({
            placeholder: 'Choose one',
            searchInputPlaceholder: 'Search',
            minimumInputLength: 5,
            allowClear: true,
            multiple: true,
            ajax: {
                url: "{{url('quality/batchcardSearch')}}",
                processResults: function (data) {
                return {
                        results: data
                    };
                }
            }
        });

        $('.inspector').select2({
    placeholder: "--- select one ---", 
    allowClear: true,
    closeOnSelect: false,
    theme: "classic",
});
</script>
@stop