
<?php $__env->startSection('content'); ?>

<div class="az-content az-content-dashboard">
  <br>
  <div class="container">
    <div class="az-content-body">
      <div class="az-content-breadcrumb">
        <span><a href="<?php echo e(url('inventory/supplier-invoice')); ?>">Supplier Invoice</a></span>
        <span>Add</span>
      </div>

      <h4 class="az-content-title">Add Supplier Invoice</h4>

      <?php if(Session::get('success')): ?>
      <div class="alert alert-success"><?php echo e(Session::get('success')); ?></div>
      <?php endif; ?>

      <?php if(Session::get('error')): ?>
      <div class="alert alert-danger"><?php echo e(Session::get('error')); ?></div>
      <?php endif; ?>

      <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
      <div class="alert alert-danger"><?php echo e($error); ?></div>
      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

      <!-- Search supplier -->
      <form method="GET" action="<?php echo e(url('inventory/supplier-invoice-view')); ?>">
        <div class="form-group">
          <label>Search Supplier</label>
          <input type="text" name="search_supplier" class="form-control" placeholder="Enter supplier name" value="<?php echo e(request('search_supplier')); ?>">
        </div>
        <button type="submit" class="btn btn-primary">Search</button>
      </form>

      <?php if(count($suppliers) > 0): ?>
      <form method="POST" action="<?php echo e(url('inventory/supplier-invoice-submit')); ?>">
        <?php echo csrf_field(); ?>

        <div class="form-group mt-4">
          <label>Select Supplier</label>
          <select name="supplier_id" class="form-control" required>
            <option value="">Choose supplier</option>
            <?php $__currentLoopData = $suppliers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $supplier): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
<option value="<?php echo e($supplier->id); ?>"><?php echo e($supplier->vendor_name); ?></option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </select>
        </div>

        <div class="form-group">
          <label>Invoice Number</label>
          <input type="text" name="invoice_number" class="form-control" required>
        </div>

        <div class="form-group">
          <label>Invoice Date</label>
          <input type="date" name="invoice_date" class="form-control" required>
        </div>
    <div class="form-group">
        <label for="order_type">Select Order Type</label>
        <select name="order_type" id="order_type" class="form-control" required>
            <option value="">-- Select Order Type --</option>
            <option value="PO">PO</option>
            <option value="WO">WO</option>
        </select>
    </div>
       
        <div class="form-group">
          <label>Material Receipt Date</label>
          <input type="date" name="material_receipt_date" class="form-control" required>
        </div>
        <button type="submit" class="btn btn-success"><i class="fas fa-save"></i> Save Invoice</button>
      </form>
      <?php endif; ?>

    </div>
  </div>
</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\adler-erp\resources\views/pages/purchase-details/supplier-invoice/supplier-invoice-add-new.blade.php ENDPATH**/ ?>