

<?php $__env->startSection('content'); ?>
<div class="container">
    <h3>Partial Invoice Entry</h3>

    <div class="mb-4 p-3 border rounded bg-light">
        <p><strong>Invoice #:</strong> <?php echo e($invoice->invoice_number); ?></p>
        <p><strong>Supplier:</strong> <?php echo e($poItem->vendor_name); ?></p>
        <p><strong>PO Number:</strong> <?php echo e($poItem->po_number); ?></p>
        <p><strong>Item Code:</strong> <?php echo e($poItem->item_code); ?> - <?php echo e($poItem->short_description); ?></p>
        <p><strong>Ordered Qty:</strong> <?php echo e(number_format($poItem->order_qty, 2)); ?> <?php echo e($poItem->unit_name); ?></p>
        <!-- <p><strong>Pending Qty:</strong> <?php echo e(number_format($poItem->pending_qty, 2)); ?> <?php echo e($poItem->unit_name); ?></p> -->
    </div>

    <form action="<?php echo e(url('invoice/partial/' . $invoice->id)); ?>" method="POST">
        <?php echo csrf_field(); ?>
        <input type="hidden" name="invoice_id" value="<?php echo e($invoice->id); ?>">
        <input type="hidden" name="po_item_id" value="<?php echo e($poItem->id); ?>">

        <div class="form-group">
            <label for="qty">Quantity to Invoice</label>
            <input type="number" name="qty" step="0.01" max="<?php echo e($poItem->pending_qty); ?>" class="form-control" required>
        </div>

        <button type="submit" class="btn btn-primary">Add Item</button>
        <a href="<?php echo e(url()->previous()); ?>" class="btn btn-secondary">Back</a>
    </form>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\adler-erp\resources\views/pages/purchase-details/supplier-invoice/partial_form.blade.php ENDPATH**/ ?>