
<?php $__env->startSection('content'); ?>

<h5>Invoice Summary</h5>


<h5>PO Items (Pending)</h5>
<label for="po-search">Search by PO Number:</label>
<input type="text" id="po-search" placeholder="Enter PO Number" class="form-control" style="width: 250px; margin-bottom: 10px;">
<label for="item-search">Search by Item Code:</label>
<input type="text" id="item-search" placeholder="Enter Item Code" 
       class="form-control" style="width: 250px; margin-bottom: 10px;">
<table class="table table-bordered" id="po-items-table">
    <thead>
        <tr>
            <th>PO Number</th>
            <th>Item Code</th>
            <th>Type</th>
            <th>Total Order Quantity</th>
            <th>Pending Quantity</th>
            <th>Item Description</th>
            <th>Rate</th>
            <th>Discount</th>
            <th>GST</th>
            <th>Supplier</th>
            <th>Action</th>
        </tr>
    </thead>
    <tbody>
        <?php $__currentLoopData = $poItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr class="po-item-row <?php echo e($item->qty_to_invoice < $item->order_qty ? 'table-warning' : ''); ?>" data-item-id="<?php echo e($item->id); ?>">
            <td><?php echo e($item->po_number); ?></td>
            <td><?php echo e($item->item_code); ?></td>
            <td><?php echo e($item->type); ?></td>
            <td><?php echo e($item->order_qty); ?></td>
            <td><?php echo e(number_format($item->qty_to_invoice, 2)); ?> <?php echo e($item->unit_name); ?></td>
            <td><?php echo e($item->short_description); ?></td>
            <td><?php echo e($item->rate); ?></td>
            <td><?php echo e($item->discount); ?></td>
            <td>
                <?php if($item->igst): ?> IGST: <?php echo e($item->igst); ?>%<br><?php endif; ?>
                <?php if($item->cgst): ?> CGST: <?php echo e($item->cgst); ?>%<br><?php endif; ?>
                <?php if($item->sgst): ?> SGST: <?php echo e($item->sgst); ?>% <?php endif; ?>
            </td>
            <td><?php echo e($item->vendor_name); ?></td>
            <td>
                
                <form action="<?php echo e(url('inventory/supplier-invoice-add-item-save')); ?>" method="POST" class="add-invoice-form">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="po_item_id" value="<?php echo e($item->id); ?>">
                    <input type="hidden" name="qty" value="<?php echo e($item->qty_to_invoice); ?>">
                    <input type="hidden" name="invoice_id" value="<?php echo e(request()->route('id')); ?>">
                    <button type="submit" class="btn btn-success btn-sm">Add Invoice</button>
                </form>

                
                <form action="<?php echo e(url('/invoice/partial/' . request()->route('id') . '/' . $item->id)); ?>" method="GET" style="margin-top: 5px;">
                    <button type="submit" class="btn btn-warning btn-sm">Partial Invoice</button>
                </form>
            </td>
        </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </tbody>
</table>


<h5>Invoice Items</h5>
<table class="table table-bordered" id="invoice-items-table">
    <thead>
        <tr>
            <th>PO Number</th>
            <th>Item Code</th>
            <th>Description</th>
            <th>Qty</th>
            <th>Rate</th>
            <th>Total</th>
            <th>Action</th>
        </tr>
    </thead>
    <tbody>
        <?php $__empty_1 = true; $__currentLoopData = $invoiceItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <tr>
                <td><?php echo e($item->po_number); ?></td>
                <td><?php echo e($item->item_code); ?></td>
                <td><?php echo e($item->short_description); ?></td>
                <td><?php echo e($item->order_qty); ?></td>
                <td><?php echo e(number_format($item->rate, 2)); ?></td>
                <td><?php echo e(number_format($item->order_qty * $item->rate, 2)); ?></td>
                <td>
                <a href="<?php echo e(url('/invoice/item/edit/' . $invoiceId . '/' . $item->id)); ?>" 
   class="btn btn-primary btn-sm">
   Edit
</a>


</td>

            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <tr>
                <td colspan="6" class="text-center">No items added to this invoice yet.</td>
            </tr>
        <?php endif; ?>
    </tbody>
</table>

<script>
$(document).ready(function() {
    $('#po-search').on('keyup', function() {
        var value = $(this).val().toLowerCase();
        $('#po-items-table tbody tr').filter(function() {
            $(this).toggle($(this).find('td:first').text().toLowerCase().indexOf(value) > -1)
        });
    });
    $('#item-search').on('keyup', function() {
        var value = $(this).val().toLowerCase();
        $('#po-items-table tbody tr').filter(function() {
            $(this).toggle($(this).find('td:eq(1)').text().toLowerCase().indexOf(value) > -1)
        });
    });
});
</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\adler-erp\resources\views/pages/purchase-details/supplier-invoice/supplier-invoice-add-item.blade.php ENDPATH**/ ?>