<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Models\AuditTrail;
use Illuminate\Http\Request;

class AuditTrailController extends Controller
{
    /**
     * Display a listing of the audit trails.
     */
    public function index()
    {
        // Get all audit records with user info
        $audits = AuditTrail::with('user')
            ->orderBy('action_timestamp', 'desc')
            ->paginate(20);

        return response()->json($audits);
    }

    /**
     * Display audit records for a specific user.
     */
    public function userAudits($userId)
    {
        $audits = AuditTrail::with('user')
            ->where('user_id', $userId)
            ->orderBy('action_timestamp', 'desc')
            ->get();

        return response()->json($audits);
    }

    /**
     * Store a newly created audit record.
     */
    public function store(Request $request)
    {
        $validated = $request->validate([
            'user_id' => 'required|exists:users,id',
            'action_type' => 'required|string|max:10',
            'action_description' => 'required|string',
        ]);

        $audit = AuditTrail::create($validated);

        return response()->json([
            'message' => 'Audit record created successfully',
            'data' => $audit
        ], 201);
    }
}
