<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AuthToken extends Model
{
    use HasFactory;
    protected $table = 'auth_tokens';
    protected $primaryKey = 'token_id';
    public $timestamps = false;

    protected $fillable = [
        'user_id',
        'token',
        'device_info',
        'expires_at',
        'created_at',
    ];

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id', 'id');
    }
}
