<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Investor extends Model
{
    use HasFactory;
     protected $table = 'investors';

    // Primary key
    protected $primaryKey = 'id';

    // Allow mass assignment for these fields
    protected $fillable = [
        'user_id',
        'first_name',
        'last_name',
        'address',
        'postcode',
        'postoffice',
        'town',
        'district',
        'state',
        'phone_number',
        'date_of_birth',
        'aadhaar_number',
        'PAN',
        'registration_date',
    ];

    // Dates casting
    protected $dates = [
        'date_of_birth',
        'registration_date',
        'created_at',
        'updated_at',
    ];

}
