<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class InvestorBankDetail extends Model
{
    use HasFactory;

    // Table name
    protected $table = 'investor_bank_details';

    // Primary key
    protected $primaryKey = 'id';

    // Fillable fields for mass assignment
    protected $fillable = [
        'investor_id',
        'bank_name',
        'account_holder_name',
        'ifsc_code',
    ];

    // Cast timestamps
    protected $dates = [
        'created_at',
        'updated_at',
    ];

    /*
    |--------------------------------------------------------------------------
    | Relationships
    |--------------------------------------------------------------------------
    */

    // A bank detail belongs to an investor
    public function investor()
    {
        return $this->belongsTo(Investor::class, 'investor_id');
    }
}
