<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class LogData extends Model
{
    use HasFactory;

    // Table name
    protected $table = 'log_data';

    // Primary key
    protected $primaryKey = 'id';

    // Fillable columns
    protected $fillable = [
        'user_id',
        'investor_snapshot',
        'action_type',
        'action_description',
        'logged_at',
    ];

    // Date casting
    protected $dates = [
        'logged_at',
        'created_at',
        'updated_at',
    ];

    /*
    |--------------------------------------------------------------------------
    | Relationships
    |--------------------------------------------------------------------------
    */

    // Each log entry belongs to a User
    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }
}
