<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class MarketData extends Model
{
    use HasFactory;
      protected $table = 'market_data';
    protected $primaryKey = 'data_id';
    public $timestamps = false;

    protected $fillable = [
        'product_id',
        'market_price',
        'market_change_percentage',
        'last_updated',
    ];

    protected $casts = [
        'last_updated' => 'datetime',
    ];

    public function product()
    {
        return $this->belongsTo(InvestmentProduct::class, 'product_id');
    }
}
