<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Nominee extends Model
{
    use HasFactory;

    // Table name
    protected $table = 'nominees';

    // Primary key
    protected $primaryKey = 'id';

    // Fillable columns
    protected $fillable = [
        'investor_id',
        'full_name',
        'first_name',
        'last_name',
        'address',
        'postcode',
        'postoffice',
        'town',
        'district',
        'state',
        'email',
        'phone_number',
        'date_of_birth',
        'aadhaar_number',
        'PAN',
    ];

    // Cast date fields
    protected $dates = [
        'date_of_birth',
        'created_at',
        'updated_at',
    ];

    /*
    |--------------------------------------------------------------------------
    | Relationships
    |--------------------------------------------------------------------------
    */

    // Nominee belongs to an Investor
    public function investor()
    {
        return $this->belongsTo(Investor::class, 'investor_id');
    }

    // Nominee has one bank detail
    public function bankDetails()
    {
        return $this->hasOne(NomineeBankDetail::class, 'nominee_id');
    }
}
