<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class NomineeBankDetail extends Model
{
    use HasFactory;

    // Table name
    protected $table = 'nominee_bank_details';

    // Primary key
    protected $primaryKey = 'id';

    // Fillable columns
    protected $fillable = [
        'nominee_id',
        'bank_name',
        'account_holder_name',
        'ifsc_code',
    ];

    // Cast timestamps
    protected $dates = [
        'created_at',
        'updated_at',
    ];

    /*
    |--------------------------------------------------------------------------
    | Relationships
    |--------------------------------------------------------------------------
    */

    // Each bank detail belongs to a nominee
    public function nominee()
    {
        return $this->belongsTo(Nominee::class, 'nominee_id');
    }
}
