<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PortfolioPerformance extends Model
{
    use HasFactory;
      protected $table = 'portfolio_performance';
    protected $primaryKey = 'performance_id';
    public $timestamps = false;

    protected $fillable = [
        'user_id',
        'date',
        'roi',
        'sharpe_ratio',
        'risk_level',
        'scenario_analysis',
    ];

    protected $casts = [
        'scenario_analysis' => 'array',
        'date' => 'datetime',
    ];

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }
}
