<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
       Schema::create('nominees', function (Blueprint $table) {
    $table->id();
    $table->foreignId('investor_id')->constrained('investors')->onDelete('cascade');
    $table->string('full_name'); 
    $table->string('first_name');
    $table->string('last_name');
    $table->text('address');
    $table->integer('postcode');
    $table->string('postoffice');
    $table->string('town');
    $table->string('district');
    $table->string('state');
    $table->string('email')->unique();
    $table->string('phone_number')->nullable();
    $table->date('date_of_birth')->nullable();
    $table->timestamps();
});

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('nominees');
    }
};
