<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
       Schema::create('legal_agreements', function (Blueprint $table) {
        $table->id('agreement_id');
        $table->enum('agreement_type', ['Terms and Conditions', 'Privacy Policy', 'NDA']);
        $table->string('version', 50)->nullable();
        $table->text('content');
        $table->timestamp('last_updated')->useCurrent();
    });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('legal_agreements');
    }
};
