<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
       Schema::create('investment_products', function (Blueprint $table) {
        $table->id('product_id');
        $table->string('product_name');
        $table->enum('product_type', ['Stock', 'Bond', 'Mutual Fund', 'ETF', 'Real Estate']);
        $table->text('description')->nullable();
        $table->enum('risk_level', ['Low', 'Medium', 'High']);
        $table->json('historical_data')->nullable();
        $table->timestamp('created_at')->useCurrent();
    });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('investment_products');
    }
};
