<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('user_investments', function (Blueprint $table) {
        $table->id('investment_id');
        $table->unsignedBigInteger('user_id');
        $table->unsignedBigInteger('product_id');
        $table->decimal('quantity', 10, 2);
        $table->decimal('profit_percentage', 10, 2)->nullable();
        $table->decimal('purchase_price', 15, 2);
        $table->decimal('current_value', 15, 2);
        $table->timestamp('invested_date')->useCurrent();

        // Foreign Keys
        $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
        $table->foreign('product_id')->references('product_id')->on('investment_products')->onDelete('cascade');
    });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('user_investments');
    }
};
