<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
            Schema::create('transactions', function (Blueprint $table) {
        $table->id('transaction_id');
        $table->unsignedBigInteger('investment_id');
        $table->enum('transaction_type', ['Deposit', 'Withdrawal', 'Reinvestment']);
        $table->decimal('amount', 15, 2);
        $table->timestamp('transaction_date')->useCurrent();
        $table->enum('status', ['Completed', 'Pending', 'Failed']);

        // Foreign key
        $table->foreign('investment_id')->references('investment_id')->on('user_investments')->onDelete('cascade');
    });
          
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('transactions');
    }
};
