<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
       Schema::create('portfolio_performance', function (Blueprint $table) {
        $table->id('performance_id');
        $table->unsignedBigInteger('user_id');
        $table->timestamp('date')->useCurrent();
        $table->decimal('roi', 10, 2);
        $table->decimal('sharpe_ratio', 10, 2)->nullable();
        $table->enum('risk_level', ['Low', 'Medium', 'High']);
        $table->json('scenario_analysis')->nullable();

        // Foreign Key
        $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
    });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('portfolio_performances');
    }
};
