<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
         Schema::create('market_data', function (Blueprint $table) {
        $table->id('data_id');
        $table->unsignedBigInteger('product_id');
        $table->decimal('market_price', 15, 2);
        $table->decimal('market_change_percentage', 5, 2);
        $table->timestamp('last_updated')->useCurrent();

        // Foreign key constraint
        $table->foreign('product_id')->references('product_id')->on('investment_products')->onDelete('cascade');
    });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('market_data');
    }
};
