<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('notifications', function (Blueprint $table) {
        $table->id('notification_id');
        $table->unsignedBigInteger('user_id');
        $table->enum('notification_type', ['Market Alert', 'Transaction Update', 'Risk Alert']);
        $table->text('message');
        $table->enum('status', ['Sent', 'Read', 'Pending'])->default('Pending');
        $table->timestamp('created_at')->useCurrent();

        $table->foreign('user_id')
              ->references('id')
              ->on('users')
              ->onDelete('cascade');
    });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('notifications');
    }
};
