<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('withdrawals_transfers', function (Blueprint $table) {
        $table->id('request_id');
        $table->unsignedBigInteger('user_id');
        $table->enum('transaction_type', ['Withdrawal', 'Transfer']);
        $table->decimal('amount', 15, 2);
        $table->enum('status', ['Pending', 'Completed', 'Failed'])->default('Pending');
        $table->timestamp('created_at')->useCurrent();

        $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
    });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('withdrawal_transfers');
    }
};
