<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('audit_trail', function (Blueprint $table) {
        $table->id('audit_id');
        $table->unsignedBigInteger('user_id');
        $table->enum('action_type', ['Login', 'Data Update', 'Transaction', 'Investment Change']);
        $table->text('action_description');
        $table->timestamp('action_timestamp')->useCurrent();

        $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
    });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('audit_trails');
    }
};
