<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('reports', function (Blueprint $table) {
        $table->id('report_id');
        $table->unsignedBigInteger('user_id');
        $table->enum('report_type', ['Tax Report', 'Performance Report', 'Investment Summary']);
        $table->text('content'); // Can store plain text or JSON
        $table->timestamp('generated_at')->useCurrent();

        $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
    });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('reports');
    }
};
