<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddAadhaarAndPanToInvestorsAndNomineesTables extends Migration
{
    public function up()
    {
        Schema::table('investors', function (Blueprint $table) {
            $table->string('aadhaar_number', 20)->nullable()->after('date_of_birth'); // adjust position if needed
            $table->string('PAN', 10)->nullable()->after('aadhaar_number');
        });

        Schema::table('nominees', function (Blueprint $table) {
            $table->string('aadhaar_number', 20)->nullable()->after('date_of_birth'); // adjust position if needed
            $table->string('PAN', 10)->nullable()->after('aadhaar_number');
        });
    }

    public function down()
    {
        Schema::table('investors', function (Blueprint $table) {
            $table->dropColumn(['aadhaar_number', 'PAN']);
        });

        Schema::table('nominees', function (Blueprint $table) {
            $table->dropColumn(['aadhaar_number', 'PAN']);
        });
    }
}
