<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Models\Campaign;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class CampaignController extends Controller
{
    /**
     * Display a listing of campaigns.
     */
    public function index()
    {
        $campaigns = Campaign::orderBy('created_at', 'desc')->get();
        return response()->json($campaigns);
    }

    /**
     * Store a newly created campaign in storage.
     */
  public function store(Request $request)
{
    // Check if the request is an array of campaigns or a single one
    if (isset($request[0]) && is_array($request[0])) {
        // Bulk insert
        $validatedData = [];
        foreach ($request->all() as $index => $data) {
            $validated = validator($data, [
                'title'       => 'required|string|max:255',
                'description' => 'nullable|string',
                'start_date'  => 'nullable|date',
                'end_date'    => 'nullable|date|after_or_equal:start_date',
                'goal_amount' => 'nullable|numeric|min:0',
            ])->validate();

            $validated['created_by'] = Auth::id();
            $validated['updated_by'] = Auth::id();
            $validated['created_at'] = now();
            $validated['updated_at'] = now();

            $validatedData[] = $validated;
        }

        Campaign::insert($validatedData);

        return response()->json([
            'message' => count($validatedData) . ' campaigns created successfully'
        ], 201);

    } else {
        // Single insert
        $validated = $request->validate([
            'title'       => 'required|string|max:255',
            'description' => 'nullable|string',
            'start_date'  => 'nullable|date',
            'end_date'    => 'nullable|date|after_or_equal:start_date',
            'goal_amount' => 'nullable|numeric|min:0',
        ]);

        $validated['created_by'] = Auth::id();
        $validated['updated_by'] = Auth::id();

        $campaign = Campaign::create($validated);

        return response()->json([
            'message'  => 'Campaign created successfully',
            'campaign' => $campaign
        ], 201);
    }
}

    /**
     * Display the specified campaign.
     */
    public function show($id)
    {
        $campaign = Campaign::findOrFail($id);
        return response()->json($campaign);
    }
      public function update(Request $request, $id)
    {
        $campaign = Campaign::findOrFail($id);

        $campaign->update($request->all());

        return response()->json([
            'message' => 'Campaign updated successfully',
            'data' => $campaign
        ]);
    }
     public function destroy($id)
    {
        $campaign = Campaign::find($id);

        if (!$campaign) {
            return response()->json([
                'message' => 'Campaign not found'
            ], 404);
        }

        $campaign->delete();

        return response()->json([
            'message' => 'Campaign deleted successfully'
        ]);
    }
}
