<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use App\Models\Document;
use Illuminate\Support\Facades\Validator;

class DocumentController extends Controller
{
    // // Upload document
    // public function upload(Request $request)
    // {
    //     $validator = Validator::make($request->all(), [
    //         'student_id'     => 'required|exists:students,id',
    //         'document_title' => 'required|string|max:255',
    //         'file'           => 'required|file|mimes:pdf,jpg,jpeg,png,doc,docx',
    //         'academic_year'  => 'required|string',
    //         'type'       => 'nullable|string|max:255',
    //     ]);

    //     if ($validator->fails()) {
    //         return response()->json(['errors' => $validator->errors()], 422);
    //     }

    //     $file = $request->file('file');
    //     $filename = time() . '_' . $file->getClientOriginalName();
    //     $path = $file->storeAs('documents/' . $request->academic_year . '/' . $request->student_id, $filename, 'public');

    //     $document = Document::create([
    //         'student_id'     => $request->student_id,
    //         'title'          => $request->document_title,
    //         'filename'       => $filename,
    //         'path'           => $path,
    //         'academic_year'  => $request->academic_year,
    //         'type'           => $request->type,
    //     ]);

    //     return response()->json(['message' => 'Document uploaded successfully', 'document' => $document], 201);
    // }

    // List documents for a student (optionally filter by year/category)
    public function getStudentDocuments(Request $request, $student_id)
    {
        $query = Document::where('student_id', $student_id);

        if ($request->has('academic_year')) {
            $query->where('academic_year', $request->academic_year);
        }

        if ($request->has('type')) {
            $query->where('type', $request->type);
        }

        return response()->json($query->get());
    }

    // Download document by ID
    public function download($id)
    {
        $document = Document::findOrFail($id);
        $filePath = 'public/' . $document->path;

        if (!Storage::exists($filePath)) {
            return response()->json(['error' => 'File not found.'], 404);
        }

        return Storage::download($filePath, $document->filename);
    }

    // Search documents by keyword (title/category/year)
    public function search(Request $request)
    {
        $keyword = $request->input('keyword');

        $documents = Document::where('title', 'LIKE', "%{$keyword}%")
            ->orWhere('academic_year', 'LIKE', "%{$keyword}%")
            ->orWhere('type', 'LIKE', "%{$keyword}%")
            ->get();

        return response()->json($documents);
    }

    // Delete document
    public function destroy($id)
    {
        $document = Document::findOrFail($id);
        Storage::delete('public/' . $document->path);
        $document->delete();

        return response()->json(['message' => 'Document deleted successfully']);
    }
}

