<?php

namespace App\Http\Controllers\API;

use App\Models\Donor;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class DonorController extends Controller
{
    // Get all donors
    public function index()
    {
        $donors = Donor::all();
        return response()->json($donors);
    }

    // Store new donor
    public function store(Request $request)
    {
        $validated = $request->validate([
            'civil_id'       => 'required|unique:donors',
            'name'           => 'required|string',
            'phone'          => 'required|string',
            'email'          => 'nullable|email',
            'amount_donated' => 'required|numeric',
        ]);

        $donor = Donor::create($validated);

        return response()->json([
            'message' => 'Donor created successfully',
            'donor'   => $donor
        ]);
    }

    // Show single donor
    public function show($id)
    {
        $donor = Donor::findOrFail($id);
        return response()->json($donor);
    }

    // Update donor
    public function update(Request $request, $id)
    {
        $donor = Donor::findOrFail($id);

        $validated = $request->validate([
            'civil_id'       => 'sometimes|unique:donors,civil_id,' . $id,
            'name'           => 'sometimes|string',
            'phone'          => 'sometimes|string',
            'email'          => 'sometimes|email|nullable',
            'amount_donated' => 'sometimes|numeric',
        ]);

        $donor->update($validated);

        return response()->json([
            'message' => 'Donor updated successfully',
            'donor'   => $donor
        ]);
    }

    // Delete donor
    public function destroy($id)
    {
        $donor = Donor::findOrFail($id);
        $donor->delete();

        return response()->json(['message' => 'Donor deleted successfully']);
    }
}

