<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class SidebarController extends Controller
{
    public function index(Request $request)
    {
        $user = $request->user();

        $sidebar = [
            'common' => [
                ['name' => 'Dashboard', 'route' => '/dashboard', 'icon' => 'home'],
                ['name' => 'Tasks', 'route' => '/tasks', 'icon' => 'list-check'],
                ['name' => 'Documents', 'route' => '/documents', 'icon' => 'file'],
            ],
            'admin' => [
                ['name' => 'Students', 'route' => '/students', 'icon' => 'users'],
                ['name' => 'Donors', 'route' => '/donors', 'icon' => 'hand-holding-usd'],
                ['name' => 'Donations', 'route' => '/donations', 'icon' => 'donate'],
                ['name' => 'Sponsorships', 'route' => '/sponsorships', 'icon' => 'user-check'],
                ['name' => 'Reports', 'route' => '/reports', 'icon' => 'chart-line'],
                ['name' => 'User Management', 'route' => '/users', 'icon' => 'user-cog'],
            ],
            'donor' => [
                ['name' => 'My Sponsorships', 'route' => '/my-sponsorships', 'icon' => 'child'],
                ['name' => 'My Reports', 'route' => '/my-reports', 'icon' => 'file-invoice-dollar'],
            ]
        ];

        $response = $sidebar['common'];

        if ($user->role === 'admin' || $user->role === 'moderator') {
            $response = array_merge($response, $sidebar['admin']);
        } elseif ($user->role === 'donor') {
            $response = array_merge($response, $sidebar['donor']);
        }

        return response()->json($response);
    }
}


