<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Document extends Model
{
    use HasFactory;

    protected $fillable = [
        'student_id',
        'type',
        'file_path',
        'academic_year',
        'created_by',
        'updated_by'
    ];

    public function student()
    {
        return $this->belongsTo(Student::class);
    }
    public function uploader()
{
    return $this->belongsTo(User::class, 'uploaded_by');//userid
}

public function verifier()
{
    return $this->belongsTo(User::class, 'verified_by');//userid
}

}

