<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Donation extends Model
{
    use HasFactory;

    protected $fillable = [
        'donor_id',
        'amount',
        'payment_method',
        'transaction_id',
        'campaign_id',
        'donation_date',
        'description',
        'created_by',
        'updated_by'
    ];

    /**
     * The donor who made the donation.
     */
    public function donor()
    {
        return $this->belongsTo(Donor::class);
    }

    /**
     * The campaign this donation is linked to (if any).
     */
    public function campaign()
    {
        return $this->belongsTo(Campaign::class);
    }

    /**
     * Sponsorships associated with this donation.
     */
    public function sponsorships()
    {
        return $this->hasMany(Sponsorship::class);
    }
}
