<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Sponsorship extends Model
{
    use HasFactory;

    protected $fillable = [
        'student_id',
        'donation_id',
        'start_date',
        'end_date',
        'created_by',
        'updated_by'
    ];

    /**
     * The student being sponsored.
     */
    public function student()
    {
        return $this->belongsTo(Student::class);
    }

    /**
     * The donation that is sponsoring the student.
     */
    public function donation()
    {
        return $this->belongsTo(Donation::class);
    }
}
