<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Student extends Model
{
    use HasFactory;

    protected $fillable = [
        'created_by','updated_by'
    
    ];

    public function documents()
{
    return $this->hasMany(Document::class);
}
 public function donor()
{
    return $this->belongsTo(Donor::class,'donor_id');
}
public function personal() {
    return $this->hasOne(StudentPersonal::class);
}

public function family() {
    return $this->hasOne(StudentFamily::class);
}

    public function academic()
{
    return $this->hasOne(StudentAcademic::class, 'student_id');
}
public function health() {
    return $this->hasOne(StudentHealth::class);
}

public function address()
{
    return $this->hasOne(StudentAddress::class);
}
    public function households()
{
    return $this->hasMany(StudentHousehold::class);
}
  public function feeRecords()
    {
        return $this->hasMany(StudentFeeRecord::class, 'student_id');
    }

}
