<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class StudentFeePaymentDetail extends Model
{
    use HasFactory;

    protected $fillable = [
        'student_fee_payment_id',
        'amount_paid',
        'payment_date',
        'payment_method',
        'transaction_id',
        'notes',
        'created_by',
        'updated_by'
    ];

    // Relationship to parent payment record
    public function feePayment()
    {
        return $this->belongsTo(StudentFeePayment::class, 'student_fee_payment_id');
    }
}
