<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class StudentFeeRecord extends Model
{
    use HasFactory;

    protected $fillable = [
        'student_id',
        'academic_year',
        'fee_amount',
        'payment_status',
        'created_by','updated_by'
    ];

    // Constants for statuses
    const STATUS_PENDING = 'pending';
    const STATUS_PAID = 'paid';

    public static function getStatuses()
    {
        return [
            self::STATUS_PENDING => 'Pending',
            self::STATUS_PAID    => 'Paid',
        ];
    }

    /**
     * Relationship: A fee record belongs to a student.
     */
    public function student()
    {
        return $this->belongsTo(Student::class);
    }
    public function scopeForYear($query, $year)
{
    return $query->where('academic_year', $year);
}

public function scopePaid($query)
{
    return $query->where('payment_status', self::STATUS_PAID);
}
public function paymentDetails()
{
    return $this->hasMany(StudentFeePaymentDetail::class);
}

}
