<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Task extends Model
{
    use HasFactory;

    protected $fillable = [
        'title',
        'description',
        'assigned_to',
        'priority_level',
        'is_recurring',
        'due_date',
        'is_completed',
        'student_id',
        'donor_id','created_by','updated_by'
    ];

    /**
     * User assigned to the task.
     */
    public function assignedUser()
    {
        return $this->belongsTo(User::class, 'assigned_to');
    }

    /**
     * Related student (optional).
     */
    public function student()
    {
        return $this->belongsTo(Student::class);
    }

    /**
     * Related donor (optional).
     */
    public function donor()
    {
        return $this->belongsTo(Donor::class);
    }
}
