<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
 public function up()
{
    Schema::table('students', function (Blueprint $table) {
        $table->string('family_name')->nullable();
        $table->string('nationality')->nullable();
        $table->string('current_condition')->nullable();
        $table->string('contact_number')->nullable();
        $table->decimal('home_rent_month', 10, 2)->nullable();
        $table->string('project_type')->nullable();
        $table->string('child_no')->nullable();
        $table->integer('number_of_children')->nullable();
        $table->string('child_name')->nullable();
        $table->string('education_level')->nullable();
        $table->string('grades')->nullable();
    });
}

public function down()
{
    Schema::table('students', function (Blueprint $table) {
        $table->dropColumn([
            'family_name',
            'nationality',
            'current_condition',
            'contact_number',
            'home_rent_month',
            'project_type',
            'child_no',
            'number_of_children',
            'child_name',
            'education_level',
            'grades',
            'school_fees_2021_2022',
            'school_fees_2022_2023',
        ]);
    });
}

};
