<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
       Schema::create('student_fee_records', function (Blueprint $table) {
    $table->id();
    $table->unsignedBigInteger('student_id');
    $table->string('academic_year');
    $table->decimal('fee_amount', 10, 2);
    $table->enum('payment_status', ['paid', 'pending'])->default('pending');
    $table->timestamps();
    $table->foreign('student_id')->references('id')->on('students')->onDelete('cascade');
});
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('student_fee_records');
    }
};
